/*
 * Decompiled with CFR 0.152.
 */
package com.github.lazyboyl.shardingsphere.springboot.starter.util;

import com.github.lazyboyl.shardingsphere.springboot.starter.util.StrUtil;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class PropertiesParser {
    private static Logger log = LoggerFactory.getLogger(PropertiesParser.class);

    public static String castToYaml(String input) {
        try {
            Map<String, Object> properties = PropertiesParser.readProperties(input);
            return PropertiesParser.properties2Yaml(properties);
        }
        catch (Exception e) {
            log.error("property \u8f6c Yaml \u8f6c\u6362\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    private static Map<String, Object> readProperties(String input) {
        LinkedHashMap<String, Object> propertiesMap = new LinkedHashMap<String, Object>();
        for (String line : input.split("\n")) {
            Pattern pattern;
            Matcher matcher;
            if (!StrUtil.isNotEmpty(line) || !(matcher = (pattern = Pattern.compile("\\s*([^=\\s]*)\\s*=\\s*(.*)\\s*")).matcher(line)).matches()) continue;
            String key = matcher.group(1);
            String value = matcher.group(2);
            propertiesMap.put(key, value);
        }
        return propertiesMap;
    }

    private static String properties2Yaml(Map<String, Object> properties) {
        if (StrUtil.mapIsEmpty(properties)) {
            return null;
        }
        Map<String, Object> map = PropertiesParser.parseToMap(properties);
        StringBuffer stringBuffer = PropertiesParser.map2Yaml(map);
        return stringBuffer.toString();
    }

    private static Map<String, Object> parseToMap(Map<String, Object> propMap) {
        LinkedHashMap<String, Object> resultMap = new LinkedHashMap<String, Object>();
        try {
            if (CollectionUtils.isEmpty(propMap)) {
                return resultMap;
            }
            propMap.forEach((key, value) -> {
                if (key.contains(".")) {
                    String currentKey = key.substring(0, key.indexOf("."));
                    if (resultMap.get(currentKey) != null) {
                        return;
                    }
                    Map<String, Object> childMap = PropertiesParser.getChildMap(propMap, currentKey);
                    Map<String, Object> map = PropertiesParser.parseToMap(childMap);
                    resultMap.put(currentKey, map);
                } else {
                    resultMap.put((String)key, value);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return resultMap;
    }

    private static Map<String, Object> getChildMap(Map<String, Object> propMap, String currentKey) {
        LinkedHashMap<String, Object> childMap = new LinkedHashMap<String, Object>();
        try {
            propMap.forEach((key, value) -> {
                if (key.startsWith(currentKey + ".")) {
                    key = key.substring(key.indexOf(".") + 1);
                    childMap.put((String)key, value);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return childMap;
    }

    public static StringBuffer map2Yaml(Map<String, Object> map) {
        return PropertiesParser.map2Yaml(map, 0);
    }

    private static StringBuffer map2Yaml(Map<String, Object> propMap, int deep) {
        StringBuffer yamlBuffer = new StringBuffer();
        try {
            if (CollectionUtils.isEmpty(propMap)) {
                return yamlBuffer;
            }
            String space = PropertiesParser.getSpace(deep);
            Boolean arrayIsAdd = false;
            for (Map.Entry<String, Object> entry : propMap.entrySet()) {
                Object valObj = entry.getValue();
                if (entry.getKey().contains("[") && entry.getKey().contains("]") && !arrayIsAdd.booleanValue()) {
                    arrayIsAdd = true;
                    Map<String, String> arrayKeyMap = PropertiesParser.loadArrayKey(propMap);
                    arrayKeyMap.forEach((arrayKey, arrayKeyVal) -> {
                        yamlBuffer.append(space + arrayKey + "\n");
                        propMap.forEach((itemKey, itemValue) -> {
                            if (itemKey.indexOf("[") != -1 && itemKey.indexOf("[") < arrayKey.length() && itemKey.startsWith(arrayKey.substring(0, itemKey.indexOf("[")))) {
                                yamlBuffer.append(PropertiesParser.getSpace(deep + 1) + "- ");
                                if (itemValue instanceof Map) {
                                    StringBuffer valStr = PropertiesParser.map2Yaml((Map)itemValue, 0);
                                    String[] split = valStr.toString().split("\n");
                                    for (int i = 0; i < split.length; ++i) {
                                        if (i > 0) {
                                            yamlBuffer.append(PropertiesParser.getSpace(deep + 2));
                                        }
                                        yamlBuffer.append(split[i]).append("\n");
                                    }
                                } else {
                                    yamlBuffer.append(itemValue + "\n");
                                }
                            }
                        });
                    });
                    continue;
                }
                if (entry.getKey().contains("[") && entry.getKey().contains("]")) continue;
                String key = space + entry.getKey() + ":";
                if (valObj instanceof String) {
                    yamlBuffer.append(key + " " + valObj + "\n");
                    continue;
                }
                if (valObj instanceof List) {
                    yamlBuffer.append(key + "\n");
                    List list = (List)entry.getValue();
                    String lSpace = PropertiesParser.getSpace(deep + 1);
                    for (String str : list) {
                        yamlBuffer.append(lSpace + "- " + str + "\n");
                    }
                    continue;
                }
                if (valObj instanceof Map) {
                    Map valMap = (Map)valObj;
                    yamlBuffer.append(key + "\n");
                    StringBuffer valStr = PropertiesParser.map2Yaml(valMap, deep + 1);
                    yamlBuffer.append(valStr.toString());
                    continue;
                }
                yamlBuffer.append(key + " " + valObj + "\n");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return yamlBuffer;
    }

    private static Map<String, String> loadArrayKey(Map<String, Object> propMap) {
        HashMap<String, String> arrayKeyMap = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : propMap.entrySet()) {
            String key;
            if (!entry.getKey().contains("[") || !entry.getKey().contains("]") || arrayKeyMap.get(key = entry.getKey().substring(0, entry.getKey().indexOf("[")) + ":") != null) continue;
            arrayKeyMap.put(key, key);
        }
        return arrayKeyMap;
    }

    private static String getSpace(int deep) {
        StringBuffer buffer = new StringBuffer();
        if (deep == 0) {
            return "";
        }
        for (int i = 0; i < deep; ++i) {
            buffer.append("  ");
        }
        return buffer.toString();
    }
}

