/*
 * Decompiled with CFR 0.152.
 */
package com.github.lazyboyl.shardingsphere.springboot.starter.sharding;

import com.github.lazyboyl.shardingsphere.springboot.starter.util.PropertiesParser;
import com.github.lazyboyl.shardingsphere.springboot.starter.util.ShardingsphereUtil;
import com.github.lazyboyl.shardingsphere.springboot.starter.util.StrUtil;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.apache.shardingsphere.driver.api.yaml.YamlShardingSphereDataSourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.env.OriginTrackedMapPropertySource;
import org.springframework.cloud.bootstrap.config.BootstrapPropertySource;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.stereotype.Component;

@Component
public class ShardingConfig {
    private Logger logger = LoggerFactory.getLogger(ShardingConfig.class);
    @Resource
    private ConfigurableEnvironment environment;

    @Bean
    public DataSource dataSource() {
        MutablePropertySources propertySources = this.environment.getPropertySources();
        HashMap propertiesMap = new HashMap();
        for (PropertySource propertySource : propertySources) {
            BootstrapPropertySource bootstrapPropertySource;
            Object object;
            if (propertySource instanceof BootstrapPropertySource && (object = (bootstrapPropertySource = (BootstrapPropertySource)propertySource).getSource()) instanceof LinkedHashMap) {
                for (Map.Entry entry : ((LinkedHashMap)object).entrySet()) {
                    String key = StrUtil.getObjStr(entry.getKey());
                    if (!key.startsWith("spring.shardingsphere")) continue;
                    propertiesMap.put(key, entry.getValue());
                }
            }
            if (!(propertySource instanceof OriginTrackedMapPropertySource)) continue;
            OriginTrackedMapPropertySource originTrackedMapPropertySource = (OriginTrackedMapPropertySource)propertySource;
            for (Map.Entry entry : ((Map)originTrackedMapPropertySource.getSource()).entrySet()) {
                String key = (String)entry.getKey();
                if (!key.startsWith("spring.shardingsphere")) continue;
                propertiesMap.put((String)entry.getKey(), entry.getValue());
            }
        }
        StringBuilder sb = new StringBuilder();
        String key = "";
        for (Map.Entry entry : propertiesMap.entrySet()) {
            key = (String)entry.getKey();
            if (key.indexOf(".props.special-chars") != -1 || key.indexOf(".props.replace-char") != -1) {
                sb.append((String)entry.getKey()).append("=").append("'").append(entry.getValue()).append("'").append("\n");
                continue;
            }
            sb.append((String)entry.getKey()).append("=").append(entry.getValue()).append("\n");
        }
        if (sb.toString().equals("")) {
            throw new RuntimeException("\u8bf7\u914d\u7f6eshardingsphere");
        }
        String configYml = PropertiesParser.castToYaml(sb.toString());
        this.logger.debug("\u914d\u7f6e\u4e3a\uff1a\n{}", (Object)configYml);
        String string = ShardingsphereUtil.getShardingConfig(configYml);
        this.logger.debug("\u8f6c\u6362\u4ee5\u540e\u7684\u914d\u7f6e\u4e3a\uff1a\n{}", (Object)string);
        DataSource dataSource = null;
        try {
            dataSource = YamlShardingSphereDataSourceFactory.createDataSource((byte[])string.getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException | SQLException throwables) {
            throwables.printStackTrace();
        }
        return dataSource;
    }
}

