/*
 * Decompiled with CFR 0.152.
 */
package pl.project13.core;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.Supplier;

class ProcessHandler
implements AutoCloseable {
    private final Process process;
    private final ExecutorService outputReaderExecutor;
    private final Future<Void> stdoutFuture;
    private final Future<String> stderrFuture;
    private String stderrOutput = null;

    public ProcessHandler(Process process, Consumer<String> stdoutLineConsumer) {
        Object processInfo;
        this.process = Objects.requireNonNull(process);
        Objects.requireNonNull(stdoutLineConsumer);
        ThreadFactory threadFactory = Executors.defaultThreadFactory();
        this.outputReaderExecutor = Executors.newFixedThreadPool(2, runnable -> {
            Thread t = threadFactory.newThread(runnable);
            t.setDaemon(true);
            return t;
        });
        try {
            processInfo = this.process.info().command().orElse("?") + " [" + this.process.pid() + "]";
        }
        catch (UnsupportedOperationException e) {
            processInfo = "<unknown-process>";
        }
        this.stdoutFuture = this.outputReaderExecutor.submit(new ProcessOutputReader<Void>("stdout reader (" + (String)processInfo + ")", this.process.getInputStream(), stdoutLineConsumer, () -> null));
        StringBuilder stderrBuilder = new StringBuilder();
        this.stderrFuture = this.outputReaderExecutor.submit(new ProcessOutputReader<String>("stderr reader (" + (String)processInfo + ")", this.process.getErrorStream(), line -> stderrBuilder.append((String)line).append('\n'), stderrBuilder::toString));
    }

    public int exitValue(long timeout, TimeUnit timeUnit) throws InterruptedException, TimeoutException, ExecutionException {
        boolean finished = this.process.waitFor(timeout, timeUnit);
        if (finished) {
            this.outputReaderExecutor.shutdown();
            try {
                this.stdoutFuture.get();
            }
            catch (ExecutionException e) {
                throw new ExecutionException("Failed waiting for stdout", e.getCause());
            }
            try {
                this.stderrOutput = this.stderrFuture.get();
            }
            catch (ExecutionException e) {
                throw new ExecutionException("Failed waiting for stderr", e.getCause());
            }
            return this.process.exitValue();
        }
        throw new TimeoutException();
    }

    public String getStderr() {
        if (this.stderrOutput == null) {
            throw new IllegalStateException("Process has not finished");
        }
        return this.stderrOutput;
    }

    @Override
    public void close() {
        this.process.destroy();
        this.outputReaderExecutor.shutdownNow();
    }

    private static class ProcessOutputReader<T>
    implements Callable<T> {
        private final String threadName;
        private final InputStream is;
        private final Consumer<String> lineConsumer;
        private final Supplier<T> resultCreator;

        ProcessOutputReader(String threadName, InputStream is, Consumer<String> lineConsumer, Supplier<T> resultCreator) {
            this.threadName = threadName;
            this.is = is;
            this.lineConsumer = lineConsumer;
            this.resultCreator = resultCreator;
        }

        @Override
        public T call() throws Exception {
            Thread.currentThread().setName(this.threadName);
            try (BufferedReader br = new BufferedReader(new InputStreamReader(this.is, StandardCharsets.UTF_8));){
                String line;
                while ((line = br.readLine()) != null) {
                    this.lineConsumer.accept(line);
                }
            }
            return this.resultCreator.get();
        }
    }
}

