/*
 * Decompiled with CFR 0.152.
 */
package pl.project13.core.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import nu.studer.java.util.OrderedProperties;
import pl.project13.core.CannotReadFileException;
import pl.project13.core.CommitIdPropertiesOutputFormat;
import pl.project13.core.GitCommitIdExecutionException;
import pl.project13.core.PropertiesFileGenerator;
import pl.project13.core.log.LogInterface;
import pl.project13.core.util.JsonManager;
import pl.project13.core.util.PropertyManager;
import pl.project13.core.util.XmlManager;
import pl.project13.core.util.YmlManager;

public class GenericFileManager {
    public static Properties readPropertiesAsUtf8(@Nonnull CommitIdPropertiesOutputFormat propertiesOutputFormat, @Nonnull File gitPropsFile) throws GitCommitIdExecutionException {
        return GenericFileManager.readProperties(propertiesOutputFormat, gitPropsFile, StandardCharsets.UTF_8);
    }

    public static Properties readProperties(@Nonnull CommitIdPropertiesOutputFormat propertiesOutputFormat, @Nonnull File gitPropsFile, @Nonnull Charset sourceCharset) throws GitCommitIdExecutionException {
        return GenericFileManager.readProperties(null, propertiesOutputFormat, gitPropsFile, sourceCharset, null);
    }

    public static Properties readProperties(@Nullable LogInterface log, @Nonnull CommitIdPropertiesOutputFormat propertiesOutputFormat, @Nonnull File gitPropsFile, @Nonnull Charset sourceCharset, @Nullable String projectName) throws GitCommitIdExecutionException {
        Properties persistedProperties;
        try {
            if (log != null) {
                log.info(String.format("Reading existing %s file [%s] (for project %s)...", propertiesOutputFormat.name().toLowerCase(), gitPropsFile.getAbsolutePath(), projectName));
            }
            switch (propertiesOutputFormat) {
                case JSON: {
                    persistedProperties = JsonManager.readJsonProperties(gitPropsFile, sourceCharset);
                    break;
                }
                case PROPERTIES: {
                    persistedProperties = PropertyManager.readProperties(gitPropsFile);
                    break;
                }
                case XML: {
                    persistedProperties = XmlManager.readXmlProperties(gitPropsFile, sourceCharset);
                    break;
                }
                case YML: {
                    persistedProperties = YmlManager.readYmlProperties(gitPropsFile, sourceCharset);
                    break;
                }
                default: {
                    throw new GitCommitIdExecutionException("Not implemented:" + propertiesOutputFormat);
                }
            }
        }
        catch (CannotReadFileException ex) {
            throw new GitCommitIdExecutionException(String.format("Cannot read file [%s] (for project %s)...", gitPropsFile.getAbsolutePath(), projectName));
        }
        return persistedProperties;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void dumpProperties(@Nullable LogInterface log, @Nonnull CommitIdPropertiesOutputFormat propertiesOutputFormat, @Nonnull File gitPropsFile, @Nonnull Charset sourceCharset, boolean escapeUnicode, @Nullable String projectName, @Nonnull Properties propertiesToDump) throws GitCommitIdExecutionException {
        try {
            if (log != null) {
                log.info(String.format("Writing %s file [%s] (for project %s)...", propertiesOutputFormat.name().toLowerCase(), gitPropsFile.getAbsolutePath(), projectName));
            }
            Files.createDirectories(gitPropsFile.getParentFile().toPath(), new FileAttribute[0]);
            try (FileOutputStream outputStream = new FileOutputStream(gitPropsFile);){
                OrderedProperties sortedLocalProperties = PropertiesFileGenerator.createOrderedProperties();
                propertiesToDump.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> sortedLocalProperties.setProperty((String)key, (String)value)));
                switch (propertiesOutputFormat) {
                    case JSON: {
                        JsonManager.dumpJson(outputStream, sortedLocalProperties, sourceCharset);
                        return;
                    }
                    case PROPERTIES: {
                        PropertyManager.dumpProperties(outputStream, sortedLocalProperties, escapeUnicode);
                        return;
                    }
                    case XML: {
                        XmlManager.dumpXml(outputStream, sortedLocalProperties, sourceCharset);
                        return;
                    }
                    case YML: {
                        YmlManager.dumpYml(outputStream, sortedLocalProperties, sourceCharset);
                        return;
                    }
                    default: {
                        throw new GitCommitIdExecutionException("Not implemented:" + propertiesOutputFormat);
                    }
                }
            }
        }
        catch (IOException ex) {
            throw new GitCommitIdExecutionException("Cannot create custom git properties file: " + gitPropsFile, ex);
        }
    }
}

