/*
 * Decompiled with CFR 0.152.
 */
package com.easycode8.easylog.trace.filter;

import java.io.IOException;
import java.util.UUID;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.util.StringUtils;

public class EasyLogTraceFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(EasyLogTraceFilter.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        try {
            this.mdc(request, response);
        }
        catch (Exception e) {
            LOGGER.warn("record mdc logger error:{}", (Object)e.getMessage());
        }
        try {
            filterChain.doFilter(servletRequest, servletResponse);
        }
        finally {
            MDC.clear();
        }
    }

    private void mdc(HttpServletRequest request, HttpServletResponse response) {
        String traceId = StringUtils.isEmpty((Object)request.getHeader("X-Trace-Id")) ? UUID.randomUUID().toString().replace("-", "") : request.getHeader("X-Trace-Id");
        MDC.put((String)"X-Trace-Id", (String)traceId);
        if (!StringUtils.isEmpty((Object)traceId)) {
            response.setHeader("X-Trace-Id", traceId);
        }
    }
}

