/*
 * Decompiled with CFR 0.152.
 */
package com.easycode8.easylog.trace.autoconfigure;

import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;

public class EasyLogTraceEnvironmentPostProcessor
implements EnvironmentPostProcessor {
    private static final String PROPERTY_SOURCE_NAME = "easylog- defaultProperties";

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (Boolean.parseBoolean(environment.getProperty("spring.easy-log.trace.enabled", "true")) && !this.existSleuthTrace(environment)) {
            map.put("logging.pattern.level", "%5p [${spring.application.name:},%X{X-Trace-Id:-}]");
        }
        this.addOrReplace(environment.getPropertySources(), map);
    }

    private void addOrReplace(MutablePropertySources propertySources, Map<String, Object> map) {
        PropertySource source;
        MapPropertySource target = null;
        if (propertySources.contains(PROPERTY_SOURCE_NAME) && (source = propertySources.get(PROPERTY_SOURCE_NAME)) instanceof MapPropertySource) {
            target = (MapPropertySource)source;
            for (String key : map.keySet()) {
                if (target.containsProperty(key)) continue;
                ((Map)target.getSource()).put(key, map.get(key));
            }
        }
        if (target == null) {
            target = new MapPropertySource(PROPERTY_SOURCE_NAME, map);
        }
        if (!propertySources.contains(PROPERTY_SOURCE_NAME)) {
            propertySources.addLast((PropertySource)target);
        }
    }

    private boolean existSleuthTrace(ConfigurableEnvironment environment) {
        boolean flag = false;
        try {
            Class.forName("org.springframework.cloud.sleuth.autoconfig.TraceEnvironmentPostProcessor");
            flag = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return flag && Boolean.parseBoolean(environment.getProperty("spring.sleuth.enabled", "true"));
    }
}

