/*
 * Decompiled with CFR 0.152.
 */
package com.easycode8.easylog.trace;

import brave.Span;
import brave.Tracer;
import com.easycode8.easylog.core.LogInfo;
import com.easycode8.easylog.core.trace.LogTracer;
import java.util.ArrayDeque;
import java.util.Deque;
import org.springframework.core.NamedThreadLocal;
import org.springframework.util.StringUtils;

public class ZipkinLogTracer
implements LogTracer {
    private static final ThreadLocal<Deque<Span>> SPAN_DEQUE = new NamedThreadLocal<Deque<Span>>("SPAN_DEQUE"){

        protected Deque<Span> initialValue() {
            return new ArrayDeque<Span>();
        }
    };
    private final Tracer tracer;

    public ZipkinLogTracer(Tracer tracer) {
        this.tracer = tracer;
    }

    public void init(LogInfo info) {
        Span span = this.tracer.nextSpan().kind(Span.Kind.SERVER).start();
        info.setTraceId(span.context().traceIdString());
        ZipkinLogTracer.push(span);
    }

    public void start(LogInfo info) {
        Span span = ZipkinLogTracer.peek();
        String spanName = info.getMethod();
        if (!info.getTitle().equals(info.getMethod())) {
            spanName = spanName + "//" + info.getTitle();
        }
        span.name(spanName);
        span.tag("param", info.getParams());
        span.tag("title", info.getTitle());
        if (StringUtils.hasText((String)info.getRequestUri())) {
            span.tag("uri", info.getRequestUri());
        }
        if (StringUtils.hasText((String)info.getOperator())) {
            span.tag("operator", info.getOperator());
        }
        if (StringUtils.hasText((String)info.getDescription())) {
            span.tag("description", info.getDescription());
        }
        if (StringUtils.hasText((String)info.getException())) {
            span.tag("exception", info.getException());
        }
        if (StringUtils.hasText((String)info.getTags())) {
            span.tag("tags", info.getTags());
        }
        if (StringUtils.hasText((String)info.getIp())) {
            span.tag("ip", info.getIp());
        }
        if (StringUtils.hasText((String)info.getException())) {
            span.tag("exception", info.getException());
        }
    }

    public void finish(LogInfo info) {
        Span span = ZipkinLogTracer.peek();
        span.tag("timeout", info.getTimeout().toString());
        if (StringUtils.hasText((String)info.getDataSnapshot())) {
            span.tag("dataSnapshot", info.getDataSnapshot());
        }
        span.finish();
        ZipkinLogTracer.poll();
    }

    public static void push(Span span) {
        SPAN_DEQUE.get().push(span);
    }

    public static Span peek() {
        return SPAN_DEQUE.get().peek();
    }

    public static void poll() {
        Deque<Span> deque = SPAN_DEQUE.get();
        deque.poll();
        if (deque.isEmpty()) {
            SPAN_DEQUE.remove();
        }
    }
}

