/*
 * Decompiled with CFR 0.152.
 */
package com.easycode8.easylog.trace;

import brave.Tracer;
import com.easycode8.easylog.core.trace.LogTracer;
import com.easycode8.easylog.trace.DefaultLogTracer;
import com.easycode8.easylog.trace.ZipkinLogTracer;
import com.easycode8.easylog.trace.filter.EasyLogTraceFilter;
import javax.servlet.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;

public abstract class LogTraceConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogTraceConfiguration.class);

    @ConditionalOnProperty(value={"spring.sleuth.enabled", "spring.zipkin.enabled", "spring.easy-log.trace.zipkin.enabled"}, matchIfMissing=true)
    @ConditionalOnClass(value={Tracer.class})
    public static class ZipKinTranceConfig {
        @Bean
        @ConditionalOnBean(value={Tracer.class})
        @ConditionalOnMissingBean
        public LogTracer logTracer(Tracer tracer) {
            LOGGER.info("[easy-log]\u65e5\u5fd7\u94fe\u8def\u542f\u7528zipkin\u8bb0\u5f55");
            return new ZipkinLogTracer(tracer);
        }
    }

    @ConditionalOnMissingBean(value={LogTracer.class})
    @ConditionalOnProperty(value={"spring.easy-log.trace.default.enabled"}, havingValue="true", matchIfMissing=true)
    public static class DefaultTraceConfig {
        @Bean
        public LogTracer logTracer() {
            LOGGER.info("[easy-log]\u65e5\u5fd7\u94fe\u8def\u542f\u7528\u9ed8\u8ba4\u8bb0\u5f55:{}", (Object)"X-Trace-Id");
            return new DefaultLogTracer();
        }

        @Bean
        @ConditionalOnMissingBean(name={"easyLogTraceFilter"})
        public FilterRegistrationBean<EasyLogTraceFilter> easyLogTraceFilter() {
            FilterRegistrationBean registrationBean = new FilterRegistrationBean();
            registrationBean.setFilter((Filter)new EasyLogTraceFilter());
            registrationBean.addUrlPatterns(new String[]{"/*"});
            registrationBean.setOrder(1);
            registrationBean.setName("easyLogTraceFilter[\u65e5\u5fd7\u94fe\u8def]");
            return registrationBean;
        }
    }
}

