/*
 * Decompiled with CFR 0.152.
 */
package com.easycode8.easylog.autoconfigure.source;

import com.easycode8.easylog.core.annotation.EasyLog;
import com.easycode8.easylog.core.annotation.EasyLogProperties;
import com.easycode8.easylog.core.aop.interceptor.AbstractCacheLogAttributeSource;
import com.easycode8.easylog.core.aop.interceptor.DefaultLogAttribute;
import com.easycode8.easylog.core.aop.interceptor.LogAttribute;
import com.easycode8.easylog.core.aop.interceptor.LogAttributeSource;
import io.swagger.annotations.ApiOperation;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwaggerLogAttributeSource
extends AbstractCacheLogAttributeSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(SwaggerLogAttributeSource.class);
    private final LogAttributeSource logAttributeSource;
    private final EasyLogProperties easyLogProperties;

    public SwaggerLogAttributeSource(LogAttributeSource logAttributeSource, EasyLogProperties easyLogProperties) {
        LOGGER.info("[easy-log]\u542f\u52a8Swagger\u65e5\u5fd7\u589e\u5f3a");
        this.logAttributeSource = logAttributeSource;
        this.easyLogProperties = easyLogProperties;
    }

    public LogAttribute doGetLogAttribute(Method method, Class<?> targetClass) {
        ApiOperation apiOperation = method.getAnnotation(ApiOperation.class);
        if (apiOperation != null && method.getAnnotation(EasyLog.class) == null) {
            DefaultLogAttribute logAttribute = DefaultLogAttribute.builder().title(apiOperation.value()).async(this.easyLogProperties.getAsync().booleanValue()).build();
            return logAttribute;
        }
        return this.logAttributeSource.getLogAttribute(method, targetClass);
    }
}

