/*
 * Decompiled with CFR 0.152.
 */
package com.easycode8.easylog.autoconfigure;

import com.easycode8.easylog.autoconfigure.source.SwaggerLogAttributeSource;
import com.easycode8.easylog.core.adapter.LogAttributeMappingAdapter;
import com.easycode8.easylog.core.annotation.EasyLogProperties;
import com.easycode8.easylog.core.aop.interceptor.AnnotationLogAttributeSource;
import com.easycode8.easylog.core.aop.interceptor.LogAttributeSource;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;

abstract class LogAttributeSourceConfiguration {
    LogAttributeSourceConfiguration() {
    }

    @ConditionalOnMissingBean(value={LogAttributeSource.class})
    static class EasyLogSource {
        EasyLogSource() {
        }

        @Bean
        public LogAttributeSource logAttributeSource(EasyLogProperties easyLogProperties, List<LogAttributeMappingAdapter> mappingAdapters) {
            return new AnnotationLogAttributeSource(easyLogProperties, mappingAdapters);
        }
    }

    @ConditionalOnMissingBean(value={LogAttributeSource.class})
    @ConditionalOnClass(value={ApiOperation.class})
    @ConditionalOnProperty(value={"spring.easy-log.scan-swagger.enabled"}, havingValue="true")
    static class SwaggerSource {
        SwaggerSource() {
        }

        @Bean
        public LogAttributeSource logAttributeSource(EasyLogProperties easyLogProperties, List<LogAttributeMappingAdapter> mappingAdapters) {
            return new SwaggerLogAttributeSource((LogAttributeSource)new AnnotationLogAttributeSource(easyLogProperties, mappingAdapters), easyLogProperties);
        }
    }
}

