/*
 * Decompiled with CFR 0.152.
 */
package com.easycode8.easylog.autoconfigure;

import com.easycode8.easylog.autoconfigure.LogAttributeSourceConfiguration;
import com.easycode8.easylog.core.adapter.ControllerLogAttributeMapping;
import com.easycode8.easylog.core.adapter.ServiceLogAttributeMapping;
import com.easycode8.easylog.core.annotation.EasyLogProperties;
import com.easycode8.easylog.core.annotation.EnableEasyLog;
import com.easycode8.easylog.core.aop.interceptor.LogAttributeSource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@EnableEasyLog
@ConditionalOnProperty(value={"spring.easy-log.enabled"}, havingValue="true", matchIfMissing=true)
public class EasyLogAutoConfiguration {

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingBean(value={LogAttributeSource.class})
    @Import(value={LogAttributeSourceConfiguration.SwaggerSource.class, LogAttributeSourceConfiguration.EasyLogSource.class})
    protected static class ChooseLogAttributeSourceConfiguration {
        protected ChooseLogAttributeSourceConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnProperty(value={"spring.easy-log.scan-service.enabled"}, havingValue="true")
        public ServiceLogAttributeMapping serviceLogAttributeMapping(EasyLogProperties easyLogProperties) {
            return new ServiceLogAttributeMapping(easyLogProperties);
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnProperty(value={"spring.easy-log.scan-controller.enabled"}, havingValue="true")
        public ControllerLogAttributeMapping controllerLogAttributeMapping(EasyLogProperties easyLogProperties) {
            return new ControllerLogAttributeMapping(easyLogProperties);
        }
    }
}

