/*
 * Decompiled with CFR 0.152.
 */
package com.easycode8.easylog.mybatis.util;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.statement.SQLDeleteStatement;
import com.alibaba.druid.sql.ast.statement.SQLUpdateStatement;
import com.alibaba.druid.sql.visitor.SQLASTOutputVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DruidSqlUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(DruidSqlUtils.class);

    public static String getSelectStatementFromUpdate(String updateSql) {
        try {
            SQLStatement stmt = (SQLStatement)SQLUtils.parseStatements((String)updateSql, (String)"mysql").get(0);
            if (stmt instanceof SQLUpdateStatement) {
                SQLUpdateStatement updateStmt = (SQLUpdateStatement)stmt;
                String tableName = updateStmt.getTableName().toString();
                SQLExpr whereExpr = updateStmt.getWhere();
                if (whereExpr != null) {
                    SQLASTOutputVisitor visitor = SQLUtils.createOutputVisitor((Appendable)new StringBuilder(), (DbType)DbType.mysql);
                    whereExpr.accept((SQLASTVisitor)visitor);
                    String whereSql = visitor.getAppender().toString();
                    String selectSql = String.format("SELECT * FROM %s WHERE %s", tableName, whereSql);
                    return selectSql;
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn("\u89e3\u6790sql\u5931\u8d25:{}", (Object)e.getMessage());
        }
        return null;
    }

    public static String getSelectStatementFromDelete(String deleteSql) {
        try {
            SQLStatement stmt = (SQLStatement)SQLUtils.parseStatements((String)deleteSql, (String)"mysql").get(0);
            if (stmt instanceof SQLDeleteStatement) {
                SQLDeleteStatement deleteStmt = (SQLDeleteStatement)stmt;
                String tableName = deleteStmt.getTableName().toString();
                SQLExpr whereExpr = deleteStmt.getWhere();
                if (whereExpr != null) {
                    SQLASTOutputVisitor visitor = SQLUtils.createOutputVisitor((Appendable)new StringBuilder(), (DbType)DbType.of((String)"mysql"));
                    whereExpr.accept((SQLASTVisitor)visitor);
                    String whereSql = visitor.getAppender().toString();
                    String selectSql = String.format("SELECT * FROM %s WHERE %s", tableName, whereSql);
                    return selectSql;
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn("\u89e3\u6790sql\u5931\u8d25:{}", (Object)e.getMessage());
        }
        return null;
    }

    public static void main(String[] args) throws IOException {
        System.out.println("====\u6d4b\u8bd5\u66f4\u65b0\u8bed\u53e5\u8f6c\u6362\u4e3a\u67e5\u8be2\u8bed\u53e5====");
        String updateSql = "UPDATE account SET name='ss', username='sss' WHERE id=10000 and age=1";
        System.out.println(DruidSqlUtils.getSelectStatementFromUpdate(updateSql));
        System.out.println("====\u6d4b\u8bd5\u5220\u9664\u8bed\u53e5\u8f6c\u6362\u4e3a\u67e5\u8be2\u8bed\u53e5====");
        String deleteSql = "DELETE FROM movies WHERE id>2 and age=1";
        System.out.println(DruidSqlUtils.getSelectStatementFromDelete(deleteSql));
        System.out.println("====\u6d4b\u8bd5\u5b50\u67e5\u8be2\u6761\u4ef6====");
        String deleteSql2 = "DELETE FROM movies t WHERE t.id>2 or t.age=(select age from user where id=2)";
        System.out.println(DruidSqlUtils.getSelectStatementFromDelete(deleteSql2));
    }
}

