/*
 * Decompiled with CFR 0.152.
 */
package com.easycode8.easylog.mybatis.plus.util;

import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.easycode8.easylog.core.LogInfo;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MybatisPlusLogUtils {
    public static final Logger LOGGER = LoggerFactory.getLogger(MybatisPlusLogUtils.class);
    public static final String LOG_DATA_HANDLER = "mybatisPlusLogDataHandler";

    public static LogInfo recordLog(LogInfo logInfo, Object target, Class<?> targetClass, Method method, Object[] args) {
        BaseMapper baseMapper = (BaseMapper)target;
        String methodName = ((Class)targetClass.getGenericInterfaces()[0]).getSimpleName() + "." + method.getName();
        logInfo.setMethod(methodName);
        return logInfo;
    }

    private static Serializable getPrimaryKey(Object et) {
        Field[] fields;
        Class<?> clazz = et.getClass();
        if (!clazz.isAnnotationPresent(TableName.class)) {
            return (Serializable)et;
        }
        TableName tableName = clazz.getAnnotation(TableName.class);
        String tbName = tableName.value();
        if (StringUtils.isBlank((CharSequence)tbName)) {
            return null;
        }
        String pkName = null;
        String pkValue = null;
        for (Field field : fields = clazz.getDeclaredFields()) {
            field.setAccessible(true);
            if (!field.isAnnotationPresent(TableId.class)) continue;
            pkName = field.getName();
            try {
                pkValue = field.get(et).toString();
            }
            catch (Exception e) {
                pkValue = null;
            }
        }
        return pkValue;
    }
}

