/*
 * Decompiled with CFR 0.152.
 */
package com.easycode8.easylog.mybatis;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.easycode8.easylog.core.LogHolder;
import com.easycode8.easylog.core.LogInfo;
import com.easycode8.easylog.mybatis.DataSnapshotHandler;
import com.easycode8.easylog.mybatis.plus.util.GenericTypeUtils;
import com.easycode8.easylog.mybatis.util.MybatisUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.logging.log4j.util.Strings;
import org.springframework.util.StringUtils;

public class MybatisPlusDataSnapshotHandler
implements DataSnapshotHandler {
    @Override
    public boolean supports(Class mapperClass, Method method) {
        LogInfo logInfo = LogHolder.peek();
        Class<?> entityClass = GenericTypeUtils.getGenericParameterType(mapperClass, BaseMapper.class);
        return logInfo != null;
    }

    @Override
    public void handle(MappedStatement mappedStatement, BoundSql boundSql, List<Map<String, Object>> originalRecords) throws IllegalAccessException {
        SqlCommandType sqlCommandType = mappedStatement.getSqlCommandType();
        LogInfo logInfo = LogHolder.peek();
        if (sqlCommandType == SqlCommandType.DELETE) {
            if (StringUtils.isEmpty((Object)logInfo.getDataSnapshot())) {
                logInfo.setDataSnapshot("deleted:" + JSON.toJSONString(originalRecords));
            } else {
                logInfo.setDataSnapshot(logInfo.getDataSnapshot() + ";deleted:" + JSON.toJSONString(originalRecords));
            }
        } else if (sqlCommandType == SqlCommandType.UPDATE) {
            Class entityClass = MybatisUtils.getEntityClassByMapper(mappedStatement, boundSql);
            Object entityObject = MybatisUtils.getEntityObjectByMapper(mappedStatement, boundSql);
            List entityList = JSONArray.parseArray((String)JSON.toJSONString(originalRecords), (Class)entityClass);
            ArrayList<String> dataSnapshot = new ArrayList<String>();
            for (Object entity : entityList) {
                dataSnapshot.add(JSON.toJSONString(MybatisUtils.compareTowObject(entity, entityObject)));
            }
            if (StringUtils.isEmpty((Object)logInfo.getDataSnapshot())) {
                logInfo.setDataSnapshot("updated:" + Strings.join(dataSnapshot, (char)','));
            } else {
                logInfo.setDataSnapshot(logInfo.getDataSnapshot() + ";updated:" + Strings.join(dataSnapshot, (char)','));
            }
        }
    }
}

