/*
 * Decompiled with CFR 0.152.
 */
package com.easycode8.easylog.mybatis;

import com.alibaba.fastjson.JSON;
import com.easycode8.easylog.core.util.LogUtils;
import com.easycode8.easylog.mybatis.DataSnapshotHandler;
import com.easycode8.easylog.mybatis.util.CamelCaseUtils;
import com.easycode8.easylog.mybatis.util.DruidSqlUtils;
import com.easycode8.easylog.mybatis.util.MybatisUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.util.CollectionUtils;

@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class})})
public class DataSnapshotInterceptor
implements Interceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataSnapshotInterceptor.class);
    private final JdbcTemplate jdbcTemplate;
    private final DataSnapshotHandler dataSnapshotHandler;

    public DataSnapshotInterceptor(JdbcTemplate jdbcTemplate, DataSnapshotHandler dataSnapshotHandler) {
        this.jdbcTemplate = jdbcTemplate;
        this.dataSnapshotHandler = dataSnapshotHandler;
    }

    public Object intercept(Invocation invocation) throws Throwable {
        Method method;
        Object[] args = invocation.getArgs();
        MappedStatement mappedStatement = (MappedStatement)args[0];
        Object parameterObject = args[1];
        BoundSql boundSql = mappedStatement.getBoundSql(parameterObject);
        String sqlId = mappedStatement.getId();
        String mapperClassName = sqlId.substring(0, sqlId.lastIndexOf("."));
        Class<?> mapperClass = Class.forName(mapperClassName);
        if (!this.dataSnapshotHandler.supports(mapperClass, method = MybatisUtils.getMethodBySqlId(sqlId))) {
            return invocation.proceed();
        }
        String title = LogUtils.createDefaultTitle((Method)method, mapperClass);
        Configuration configuration = mappedStatement.getConfiguration();
        SqlCommandType sqlCommandType = mappedStatement.getSqlCommandType();
        if (sqlCommandType == SqlCommandType.UPDATE || sqlCommandType == SqlCommandType.DELETE) {
            String realSql = MybatisUtils.showSql(configuration, boundSql);
            LOGGER.info("[easy-log][{}] sql ==> {}", (Object)title, (Object)realSql);
            List<Map<String, Object>> originalRecords = this.getOriginalRecords(sqlCommandType, realSql);
            LOGGER.info("[easy-log][{}] original data <== {}", (Object)title, (Object)JSON.toJSONString(originalRecords));
            this.dataSnapshotHandler.handle(mappedStatement, boundSql, originalRecords);
        }
        return invocation.proceed();
    }

    private List<Map<String, Object>> getOriginalRecords(SqlCommandType sqlCommandType, String realSql) {
        String selectSql = "";
        if (sqlCommandType == SqlCommandType.DELETE) {
            selectSql = DruidSqlUtils.getSelectStatementFromDelete(realSql);
        } else if (sqlCommandType == SqlCommandType.UPDATE) {
            selectSql = DruidSqlUtils.getSelectStatementFromUpdate(realSql);
        } else {
            return new ArrayList<Map<String, Object>>();
        }
        LOGGER.debug("select old data:{}", (Object)selectSql);
        List data = this.jdbcTemplate.queryForList(selectSql);
        if (CollectionUtils.isEmpty((Collection)data)) {
            return new ArrayList<Map<String, Object>>();
        }
        for (Map map : data) {
            HashSet keySet = new HashSet(map.keySet());
            keySet.forEach(key -> {
                Object value = map.get(key);
                map.remove(key);
                LOGGER.debug(key + " => " + CamelCaseUtils.toCamelCase(key));
                map.put(CamelCaseUtils.toCamelCase(key), value);
            });
        }
        return data;
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }
}

