/*
 * Decompiled with CFR 0.152.
 */
package com.easycode8.easylog.mybatis.util;

import com.easycode8.easylog.mybatis.CompareResult;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMap;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.type.TypeHandlerRegistry;
import org.springframework.cglib.proxy.Proxy;

public abstract class MybatisUtils {
    public static void showSql(Configuration configuration, BoundSql boundSql, String sqlId) {
        Object parameterObject = boundSql.getParameterObject();
        List parameterMappings = boundSql.getParameterMappings();
        String sql = boundSql.getSql().replaceAll("[\\s]+", " ");
        if (parameterMappings.size() > 0 && parameterObject != null) {
            TypeHandlerRegistry typeHandlerRegistry = configuration.getTypeHandlerRegistry();
            if (typeHandlerRegistry.hasTypeHandler(parameterObject.getClass())) {
                sql = sql.replaceFirst("\\?", MybatisUtils.getParameterValue(parameterObject));
            } else {
                MetaObject metaObject = configuration.newMetaObject(parameterObject);
                for (ParameterMapping parameterMapping : parameterMappings) {
                    Object obj;
                    String propertyName = parameterMapping.getProperty();
                    if (metaObject.hasGetter(propertyName)) {
                        obj = metaObject.getValue(propertyName);
                        sql = sql.replaceFirst("\\?", MybatisUtils.getParameterValue(obj));
                        continue;
                    }
                    if (!boundSql.hasAdditionalParameter(propertyName)) continue;
                    obj = boundSql.getAdditionalParameter(propertyName);
                    sql = sql.replaceFirst("\\?", MybatisUtils.getParameterValue(obj));
                }
            }
        }
        System.out.println(sql);
    }

    public static String showSql(Configuration configuration, BoundSql boundSql) {
        Object parameterObject = boundSql.getParameterObject();
        List parameterMappings = boundSql.getParameterMappings();
        String sql = boundSql.getSql().replaceAll("[\\s]+", " ");
        if (parameterMappings.size() > 0 && parameterObject != null) {
            TypeHandlerRegistry typeHandlerRegistry = configuration.getTypeHandlerRegistry();
            if (typeHandlerRegistry.hasTypeHandler(parameterObject.getClass())) {
                sql = sql.replaceFirst("\\?", MybatisUtils.getParameterValue(parameterObject));
            } else {
                MetaObject metaObject = configuration.newMetaObject(parameterObject);
                for (ParameterMapping parameterMapping : parameterMappings) {
                    Object obj;
                    String propertyName = parameterMapping.getProperty();
                    if (metaObject.hasGetter(propertyName)) {
                        obj = metaObject.getValue(propertyName);
                        sql = sql.replaceFirst("\\?", MybatisUtils.getParameterValue(obj));
                        continue;
                    }
                    if (!boundSql.hasAdditionalParameter(propertyName)) continue;
                    obj = boundSql.getAdditionalParameter(propertyName);
                    sql = sql.replaceFirst("\\?", MybatisUtils.getParameterValue(obj));
                }
            }
        }
        return sql;
    }

    private static String getParameterValue(Object obj) {
        String value;
        if (obj instanceof String) {
            value = "'" + obj.toString() + "'";
        } else if (obj instanceof Date) {
            DateFormat formatter = DateFormat.getDateTimeInstance(2, 2, Locale.CHINA);
            value = "'" + formatter.format(new Date()) + "'";
        } else {
            value = obj != null ? obj.toString() : "";
        }
        return value.replace("$", "\\$");
    }

    public static Method getMethodBySqlId(String sqlId) throws ClassNotFoundException {
        String mapperClassName = sqlId.substring(0, sqlId.lastIndexOf("."));
        Class<?> mapperClass = Class.forName(mapperClassName);
        if (mapperClass.getSuperclass() != null && Proxy.isProxyClass(mapperClass)) {
            mapperClass = mapperClass.getInterfaces()[0];
        }
        String methodName = sqlId.substring(sqlId.lastIndexOf(".") + 1);
        Method[] methods = mapperClass.getMethods();
        Method method = null;
        for (Method m : methods) {
            if (!m.getName().equals(methodName)) continue;
            method = m;
            break;
        }
        return method;
    }

    public static Class getEntityClassByMapper(MappedStatement mappedStatement, BoundSql boundSql) {
        Class entityClass;
        ParameterMap parameterMap = mappedStatement.getParameterMap();
        Object parameterObject = boundSql.getParameterObject();
        if (parameterMap != null && parameterMap.getType() != null) {
            entityClass = parameterMap.getType();
        } else if (parameterObject != null) {
            entityClass = parameterObject.getClass();
        } else {
            throw new RuntimeException("\u65e0\u6cd5\u83b7\u53d6\u5b9e\u4f53\u7c7b\u578b");
        }
        return entityClass;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object getEntityObjectByMapper(MappedStatement mappedStatement, BoundSql boundSql) {
        Object entity;
        Class entityClass = MybatisUtils.getEntityClassByMapper(mappedStatement, boundSql);
        Object parameterObject = boundSql.getParameterObject();
        if (parameterObject == null) {
            return null;
        }
        if (parameterObject instanceof Map) {
            Map paramMap = (Map)parameterObject;
            if (paramMap.containsKey("et")) {
                entity = paramMap.get("et");
            } else {
                if (!paramMap.containsKey("param1")) return null;
                entity = paramMap.get("param1");
            }
        } else {
            entity = parameterObject;
        }
        if (entityClass.isInstance(entity)) return entity;
        return null;
    }

    public static List<CompareResult> compareTowObject(Object oldObj, Object newObj, Function<Field, String> function) throws IllegalAccessException {
        ArrayList<CompareResult> list = new ArrayList<CompareResult>();
        Class<?> clazz1 = oldObj.getClass();
        Class<?> clazz2 = newObj.getClass();
        Field[] field1 = clazz1.getDeclaredFields();
        Field[] field2 = clazz2.getDeclaredFields();
        block0: for (int i = 0; i < field1.length; ++i) {
            for (int j = 0; j < field2.length; ++j) {
                if (!field1[i].getName().equals(field2[j].getName())) continue;
                field1[i].setAccessible(true);
                field2[j].setAccessible(true);
                if (field2[j].get(newObj) == null) continue;
                if (MybatisUtils.compareTwo(field1[i].get(oldObj), field2[j].get(newObj))) continue block0;
                CompareResult r = new CompareResult();
                r.setFieldName(field1[i].getName());
                r.setOldValue(field1[i].get(oldObj));
                r.setNewValue(field2[j].get(newObj));
                if (function != null) {
                    r.setFieldComment(function.apply(field1[i]));
                }
                list.add(r);
                continue block0;
            }
        }
        return list;
    }

    public static List<CompareResult> compareTowObject(Object oldObj, Object newObj) throws IllegalAccessException {
        if (oldObj == null || newObj == null) {
            return new ArrayList<CompareResult>();
        }
        return MybatisUtils.compareTowObject(oldObj, newObj, null);
    }

    private static boolean compareTwo(Object object1, Object object2) {
        if (object1 == null && object2 == null) {
            return true;
        }
        if (object1 == null && object2 != null) {
            return false;
        }
        return object1.equals(object2);
    }
}

