/*
 * Decompiled with CFR 0.152.
 */
package com.easycode8.easylog.mybatis.interceptor;

import com.alibaba.fastjson.JSON;
import com.easycode8.easylog.core.util.LogUtils;
import com.easycode8.easylog.mybatis.handler.DataSnapshotHandler;
import com.easycode8.easylog.mybatis.util.CamelCaseUtils;
import com.easycode8.easylog.mybatis.util.MybatisUtils;
import com.easycode8.easylog.mybatis.util.SqlUtils;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class})})
public class DataSnapshotInterceptor
implements Interceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataSnapshotInterceptor.class);
    private final JdbcTemplate jdbcTemplate;
    private final DataSnapshotHandler dataSnapshotHandler;

    public DataSnapshotInterceptor(JdbcTemplate jdbcTemplate, DataSnapshotHandler dataSnapshotHandler) {
        this.jdbcTemplate = jdbcTemplate;
        this.dataSnapshotHandler = dataSnapshotHandler;
    }

    public Object intercept(Invocation invocation) throws Throwable {
        Method method;
        Object[] args = invocation.getArgs();
        MappedStatement mappedStatement = (MappedStatement)args[0];
        Object parameterObject = args[1];
        BoundSql boundSql = mappedStatement.getBoundSql(parameterObject);
        String sqlId = mappedStatement.getId();
        String mapperClassName = sqlId.substring(0, sqlId.lastIndexOf("."));
        Class<?> mapperClass = Class.forName(mapperClassName);
        if (!this.dataSnapshotHandler.supports(mapperClass, method = MybatisUtils.getMethodBySqlId(sqlId))) {
            return invocation.proceed();
        }
        String title = LogUtils.createDefaultTitle((Method)method, mapperClass);
        Configuration configuration = mappedStatement.getConfiguration();
        SqlCommandType sqlCommandType = mappedStatement.getSqlCommandType();
        if (sqlCommandType == SqlCommandType.UPDATE || sqlCommandType == SqlCommandType.DELETE) {
            try {
                String realSql = MybatisUtils.showSql(configuration, boundSql);
                LOGGER.info("[easy-log][{}] sql ==> {}", (Object)title, (Object)realSql);
                Class entityClass = MybatisUtils.getEntityClassByMapper(mappedStatement, boundSql);
                List originalRecords = this.getOriginalRecords(sqlCommandType, realSql, entityClass);
                LOGGER.info("[easy-log][{}] original data <== {}", (Object)title, (Object)JSON.toJSONString((Object)originalRecords));
                this.dataSnapshotHandler.handle(mappedStatement, boundSql, originalRecords);
            }
            catch (Exception ex) {
                LOGGER.warn("[easy-log][{}] record DataSnapshot failure cause:{}", new Object[]{title, ex.getMessage(), ex});
            }
        }
        return invocation.proceed();
    }

    private List getOriginalRecords(SqlCommandType sqlCommandType, String realSql, Class entityClass) {
        String selectSql = "";
        if (sqlCommandType == SqlCommandType.DELETE) {
            selectSql = SqlUtils.convertDeleteToSelect(realSql);
            List data = this.jdbcTemplate.queryForList(selectSql);
            if (CollectionUtils.isEmpty((Collection)data)) {
                return new ArrayList();
            }
            for (Map map : data) {
                HashSet keySet = new HashSet(map.keySet());
                keySet.forEach(key -> {
                    Object value = map.get(key);
                    map.remove(key);
                    LOGGER.debug(key + " => " + CamelCaseUtils.toCamelCase(key));
                    map.put(CamelCaseUtils.toCamelCase(key), value);
                });
            }
            return data;
        }
        if (sqlCommandType == SqlCommandType.UPDATE) {
            selectSql = SqlUtils.convertUpdateToSelect(realSql);
            LOGGER.debug("[easy-log] select original data:{}", (Object)selectSql);
            if (StringUtils.isEmpty((Object)selectSql)) {
                return new ArrayList();
            }
            return this.jdbcTemplate.query(selectSql, new CustomObjectRowMapper(entityClass));
        }
        return new ArrayList();
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    static class CustomObjectRowMapper<T>
    extends BeanPropertyRowMapper<T> {
        public CustomObjectRowMapper(Class<T> targetType) {
            super(targetType);
            this.setPrimitivesDefaultedForNullValue(true);
        }

        protected Object getColumnValue(ResultSet rs, int index, PropertyDescriptor pd) throws SQLException {
            if (!BeanUtils.isSimpleProperty(pd.getPropertyType())) {
                return null;
            }
            return super.getColumnValue(rs, index, pd);
        }
    }
}

