/*
 * Decompiled with CFR 0.152.
 */
package com.easycode8.easylog.core.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.easycode8.easylog.core.LogInfo;
import com.easycode8.easylog.core.aop.interceptor.LogAttribute;
import com.easycode8.easylog.core.util.SpringSpelUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Controller;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public abstract class LogUtils {
    public static void initLog(LogInfo info, LogAttribute logAttribute, Method method, Object[] args, Class<?> targetClass) {
        info.setLogId(UUID.randomUUID().toString().replace("-", ""));
        info.setTitle(logAttribute.title());
        info.setOperator(SpringSpelUtils.parse(method, args, logAttribute.operator()));
        info.setOperateDate(new Date());
        if (RequestContextHolder.getRequestAttributes() != null && targetClass.getAnnotation(Controller.class) != null || targetClass.getAnnotation(RestController.class) != null) {
            HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
            info.setRequestUri(request.getRequestURI() + " [" + request.getMethod() + "]");
            info.setIp(request.getRemoteAddr());
            if (StringUtils.isEmpty((Object)info.getType())) {
                info.setType("web");
            }
            info.setParams(LogUtils.buildRequestParams(request.getParameterMap(), args));
        } else {
            info.setParams(LogUtils.buildRequestParams(null, args));
        }
        if (targetClass.getAnnotation(Service.class) != null && StringUtils.isEmpty((Object)info.getType())) {
            info.setType("service");
        }
        if (!CollectionUtils.isEmpty(logAttribute.tags())) {
            JSONObject tags = new JSONObject();
            for (Map.Entry<String, String> item : logAttribute.tags().entrySet()) {
                tags.put(item.getKey(), (Object)SpringSpelUtils.parse(method, args, item.getValue()));
            }
            info.setTags(JSON.toJSONString((Object)tags));
        }
        info.setMethod(LogUtils.createDefaultTitle(method, targetClass));
        String spelDescription = SpringSpelUtils.parse(method, args, logAttribute.template());
        info.setDescription(spelDescription);
    }

    public static String buildRequestParams(Map<String, String[]> paramMap, Object[] args) {
        if (CollectionUtils.isEmpty(paramMap)) {
            ArrayList<String> paramList = new ArrayList<String>();
            for (Object obj : args) {
                try {
                    paramList.add(JSON.toJSONString((Object)obj));
                }
                catch (Exception e) {
                    paramList.add("notSerializableParam");
                }
            }
            return String.join((CharSequence)",", paramList);
        }
        StringBuilder params = new StringBuilder();
        for (Map.Entry<String, String[]> param : paramMap.entrySet()) {
            params.append(("".equals(params.toString()) ? "" : "&") + param.getKey() + "=");
            String paramValue = param.getValue() != null && param.getValue().length > 0 ? param.getValue()[0] : "";
            params.append(paramValue);
        }
        return params.toString();
    }

    public static String createDefaultTitle(Method method, Class<?> targetClass) {
        return LogUtils.createDefaultTitle(method, targetClass, true);
    }

    public static String createDefaultTitle(Method method, Class<?> targetClass, boolean isSimpleName) {
        StringBuilder title = new StringBuilder();
        if (isSimpleName) {
            title.append(targetClass.getSimpleName());
        } else {
            title.append(targetClass.getName());
        }
        title.append("." + method.getName());
        if (method.getParameters() != null) {
            List paramNames = Arrays.stream(method.getParameters()).map(item -> item.getName()).collect(Collectors.toList());
            title.append("(" + String.join((CharSequence)",", paramNames) + ")");
        } else {
            title.append("()");
        }
        return title.toString();
    }
}

