/*
 * Decompiled with CFR 0.152.
 */
package com.easycode8.easylog.core.provider;

import com.easycode8.easylog.core.annotation.EasyLogProperties;
import com.easycode8.easylog.core.provider.OperatorProvider;
import com.easycode8.easylog.core.util.SpringSpelUtils;
import javax.servlet.http.HttpServletRequest;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class SessionOperatorProvider
implements OperatorProvider {
    private static final String PREFIX_SESSION = "SESSION.";
    private static final String PREFIX_HEADER = "HEADER.";
    private final EasyLogProperties easyLogProperties;

    public SessionOperatorProvider(EasyLogProperties easyLogProperties) {
        this.easyLogProperties = easyLogProperties;
    }

    @Override
    public String currentOperator() {
        String operator = "";
        if (StringUtils.isEmpty((Object)this.easyLogProperties.getOperator())) {
            return operator;
        }
        if (this.easyLogProperties.getOperator().startsWith(PREFIX_SESSION)) {
            String[] info = this.easyLogProperties.getOperator().replace(PREFIX_SESSION, "").split("\\.", 2);
            operator = (String)SpringSpelUtils.getSessionAttribute(info[0], info[1]);
        }
        if (this.easyLogProperties.getOperator().startsWith(PREFIX_HEADER)) {
            String expression = this.easyLogProperties.getOperator().replace(PREFIX_HEADER, "");
            HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
            operator = request.getHeader(expression);
        }
        return operator;
    }
}

