/*
 * Decompiled with CFR 0.152.
 */
package com.easycode8.easylog.core.aop.interceptor;

import com.easycode8.easylog.core.LogDataHandler;
import com.easycode8.easylog.core.LogHolder;
import com.easycode8.easylog.core.LogInfo;
import com.easycode8.easylog.core.LogStopWatch;
import com.easycode8.easylog.core.aop.interceptor.LogAttribute;
import com.easycode8.easylog.core.aop.interceptor.LogAttributeSource;
import com.easycode8.easylog.core.provider.OperatorProvider;
import com.easycode8.easylog.core.util.LogUtils;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.BeanFactoryAnnotationUtils;
import org.springframework.lang.Nullable;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.util.StringUtils;

public abstract class LogAspectSupport
implements BeanFactoryAware,
InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogAspectSupport.class);
    private LogAttributeSource logAttributeSource;
    private LogDataHandler logDataHandler;
    private ThreadPoolTaskExecutor threadPoolTaskExecutor;
    private OperatorProvider operatorProvider;
    @Nullable
    private BeanFactory beanFactory;

    protected Object invoke(Method method, @Nullable Class<?> targetClass, Object[] args, Object targetObject, InvocationCallback invocation) throws Throwable {
        LogAttribute logAttribute = this.getLogAttributeSource().getLogAttribute(method, targetClass);
        if (!logAttribute.active().booleanValue()) {
            return invocation.proceedWithLog();
        }
        LogDataHandler handler = this.determineLogHandleAdapter(logAttribute);
        long startTime = System.currentTimeMillis();
        Object info = handler.init(logAttribute, method, args, targetClass);
        LogHolder.push(info);
        String handlerName = handler.getClass().getSimpleName();
        LogStopWatch stopWatch = new LogStopWatch(LOGGER, logAttribute.title());
        stopWatch.start("{}.init() //\u65e5\u5fd7\u521d\u59cb\u5316\u5c5e\u6027", handlerName);
        LogUtils.initLog(info, logAttribute, method, args, targetClass);
        this.chooseOperatorIfEmpty((LogInfo)info, this.operatorProvider);
        ((LogInfo)info).setStatus(LogInfo.STATUS_INIT);
        boolean isAsync = logAttribute.async();
        Object returnValue = null;
        try {
            stopWatch.stop().start("{}.before() //\u65e5\u5fd7\u524d\u5904\u7406", handlerName);
            handler.before(info, method, args, targetClass, targetObject);
            ((LogInfo)info).setStatus(LogInfo.STATUS_BEFORE);
            stopWatch.stop().start("{} //{} param:{}", ((LogInfo)info).getMethod(), ((LogInfo)info).getTitle(), ((LogInfo)info).getParams());
            returnValue = invocation.proceedWithLog();
            ((LogInfo)info).setTimeout(System.currentTimeMillis() - startTime);
            stopWatch.stop().start(handlerName + ".after() //\u65e5\u5fd7\u540e\u5904\u7406");
            ((LogInfo)info).setStatus(LogInfo.STATUS_FINISH);
            this.chooseOperatorIfEmpty((LogInfo)info, this.operatorProvider);
            if (isAsync) {
                Object retVal = returnValue;
                this.threadPoolTaskExecutor.execute(() -> handler.after(info, method, targetClass, retVal));
            } else {
                handler.after(info, method, targetClass, returnValue);
            }
            stopWatch.stop().showDetail();
        }
        catch (Throwable ex) {
            ((LogInfo)info).setTimeout(System.currentTimeMillis() - startTime);
            if (LogInfo.STATUS_INIT == ((LogInfo)info).getStatus()) {
                LOGGER.error("[easy-log] handle before {} error:{}", new Object[]{LogUtils.createDefaultTitle(method, targetClass), ex.getMessage(), ex});
            } else if (LogInfo.STATUS_BEFORE == ((LogInfo)info).getStatus()) {
                ((LogInfo)info).setException(ex.getMessage());
                if (isAsync) {
                    Object retVal = returnValue;
                    this.threadPoolTaskExecutor.execute(() -> handler.after(info, method, targetClass, retVal));
                } else {
                    handler.after(info, method, targetClass, returnValue);
                }
            } else if (LogInfo.STATUS_FINISH == ((LogInfo)info).getStatus()) {
                LOGGER.error("[easy-log] handle after {} error:{}", new Object[]{LogUtils.createDefaultTitle(method, targetClass), ex.getMessage(), ex});
            }
            throw ex;
        }
        finally {
            LogHolder.poll();
        }
        return returnValue;
    }

    protected void chooseOperatorIfEmpty(LogInfo info, OperatorProvider operatorProvider) {
        if (operatorProvider != null && StringUtils.isEmpty((Object)info.getOperator())) {
            info.setOperator(operatorProvider.currentOperator());
        }
    }

    protected LogDataHandler determineLogHandleAdapter(LogAttribute logAttribute) {
        if (logAttribute == null || this.beanFactory == null) {
            return this.getLogDataHandler();
        }
        String qualifier = logAttribute.handler();
        if (StringUtils.hasText((String)qualifier)) {
            LogDataHandler logDataHandler = (LogDataHandler)BeanFactoryAnnotationUtils.qualifiedBeanOfType((BeanFactory)this.beanFactory, LogDataHandler.class, (String)qualifier);
            return logDataHandler;
        }
        LogDataHandler defaultLogDataHandler = this.getLogDataHandler();
        if (defaultLogDataHandler == null) {
            defaultLogDataHandler = (LogDataHandler)this.beanFactory.getBean(LogDataHandler.class);
        }
        return defaultLogDataHandler;
    }

    public void afterPropertiesSet() {
        if (this.getLogDataHandler() == null && this.beanFactory == null) {
            throw new IllegalStateException("Set the 'LogDataHandler' property or make sure to run within a BeanFactory containing a LogDataHandler bean!");
        }
        if (this.getLogAttributeSource() == null) {
            throw new IllegalStateException("Either 'LogAttributeSource' or 'LogAttribute' is required: If there are no log methods, then don't use a log aspect.");
        }
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public LogAttributeSource getLogAttributeSource() {
        return this.logAttributeSource;
    }

    public void setLogAttributeSource(LogAttributeSource logAttributeSource) {
        this.logAttributeSource = logAttributeSource;
    }

    public LogDataHandler getLogDataHandler() {
        return this.logDataHandler;
    }

    public void setLogDataHandler(LogDataHandler logDataHandler) {
        this.logDataHandler = logDataHandler;
    }

    public void setThreadPoolTaskExecutor(ThreadPoolTaskExecutor threadPoolTaskExecutor) {
        this.threadPoolTaskExecutor = threadPoolTaskExecutor;
    }

    public void setOperatorProvider(OperatorProvider operatorProvider) {
        this.operatorProvider = operatorProvider;
    }

    @FunctionalInterface
    protected static interface InvocationCallback {
        @Nullable
        public Object proceedWithLog() throws Throwable;
    }
}

