/*
 * Decompiled with CFR 0.152.
 */
package com.easycode8.easylog.core.aop.interceptor;

import com.easycode8.easylog.core.aop.interceptor.LogAttribute;
import com.easycode8.easylog.core.aop.interceptor.LogAttributeSource;
import com.easycode8.easylog.core.util.LogUtils;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AbstractCacheLogAttributeSource
implements LogAttributeSource {
    private ConcurrentHashMap<String, LogAttribute> cacheMap = new ConcurrentHashMap();

    @Override
    public LogAttribute getLogAttribute(Method method, Class<?> targetClass) {
        String key = LogUtils.createDefaultTitle(method, targetClass, false);
        if (this.cacheMap.containsKey(key)) {
            return this.cacheMap.get(key);
        }
        LogAttribute attribute = this.doGetLogAttribute(method, targetClass);
        if (attribute != null) {
            this.cacheMap.put(key, attribute);
        }
        return attribute;
    }

    public abstract LogAttribute doGetLogAttribute(Method var1, Class<?> var2);

    public ConcurrentHashMap<String, LogAttribute> getCacheMap() {
        return this.cacheMap;
    }
}

