/*
 * Decompiled with CFR 0.152.
 */
package com.easycode8.easylog.core.adapter;

import com.easycode8.easylog.core.adapter.LogAttributeMappingAdapter;
import com.easycode8.easylog.core.annotation.EasyLogProperties;
import com.easycode8.easylog.core.aop.interceptor.DefaultLogAttribute;
import com.easycode8.easylog.core.aop.interceptor.LogAttribute;
import com.easycode8.easylog.core.util.LogUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

public class ServiceLogAttributeMapping
implements LogAttributeMappingAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceLogAttributeMapping.class);
    private final EasyLogProperties easyLogProperties;

    public ServiceLogAttributeMapping(EasyLogProperties easyLogProperties) {
        LOGGER.info("[easy-log]\u542f\u52a8service bean\u65e5\u5fd7\u589e\u5f3a");
        this.easyLogProperties = easyLogProperties;
    }

    @Override
    public LogAttribute getLogAttribute(Method method, Class<?> targetClass) {
        if (this.isServicePublicMethod(method, targetClass)) {
            String title = LogUtils.createDefaultTitle(method, targetClass);
            return DefaultLogAttribute.builder().title(title).async(this.easyLogProperties.getAsync()).build();
        }
        return null;
    }

    private boolean isServicePublicMethod(Method method, Class<?> targetClass) {
        if (method.getDeclaringClass().equals(Object.class)) {
            return false;
        }
        return this.easyLogProperties.getScanService().getEnabled() != false && targetClass.getAnnotation(Service.class) != null && !Modifier.isStatic(method.getModifiers()) && Modifier.isPublic(method.getModifiers());
    }
}

