/*
 * Decompiled with CFR 0.152.
 */
package com.easycode8.easylog.core.adapter;

import com.easycode8.easylog.core.adapter.LogAttributeMappingAdapter;
import com.easycode8.easylog.core.annotation.EasyLogProperties;
import com.easycode8.easylog.core.aop.interceptor.DefaultLogAttribute;
import com.easycode8.easylog.core.aop.interceptor.LogAttribute;
import com.easycode8.easylog.core.util.LogUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

public class ControllerLogAttributeMapping
implements LogAttributeMappingAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ControllerLogAttributeMapping.class);
    private final EasyLogProperties easyLogProperties;

    public ControllerLogAttributeMapping(EasyLogProperties easyLogProperties) {
        LOGGER.info("[easy-log]\u542f\u52a8controller bean\u65e5\u5fd7\u589e\u5f3a");
        this.easyLogProperties = easyLogProperties;
    }

    @Override
    public LogAttribute getLogAttribute(Method method, Class<?> targetClass) {
        if (this.easyLogProperties.getScanController().getEnabled().booleanValue() && this.isControllerPublicMethod(method, targetClass)) {
            String title = LogUtils.createDefaultTitle(method, targetClass);
            return DefaultLogAttribute.builder().title(title).async(this.easyLogProperties.getAsync()).build();
        }
        return null;
    }

    private boolean isControllerPublicMethod(Method method, Class<?> targetClass) {
        return targetClass.getAnnotation(Controller.class) != null && (method.getAnnotation(ResponseBody.class) != null || method.getReturnType() == ResponseEntity.class) || targetClass.getAnnotation(RestController.class) != null && !Modifier.isStatic(method.getModifiers()) && Modifier.isPublic(method.getModifiers());
    }
}

