/*
 * Decompiled with CFR 0.152.
 */
package com.easycode8.easylog.core;

import com.easycode8.easylog.core.LogDataHandler;
import com.easycode8.easylog.core.LogInfo;
import com.easycode8.easylog.core.aop.interceptor.LogAttribute;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLogHandler
implements LogDataHandler<LogInfo> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultLogHandler.class);

    @Override
    public LogInfo init(LogAttribute logAttribute, Method method, Object[] args, Class<?> targetClass) {
        return new LogInfo();
    }

    @Override
    public void before(LogInfo info, Method method, Object[] args, Class<?> targetClass, Object targetObject) {
        LOGGER.info("[easy-log][{}]--begin operator:[{}] param:{}", new Object[]{info.getTitle(), info.getOperator(), info.getParams()});
    }

    @Override
    public void after(LogInfo info, Method method, Class<?> targetClass, Object returnValue) {
        if (LogInfo.STATUS_FINISH == info.getStatus()) {
            LOGGER.info("[easy-log][{}]--end timeout:{} data:{}", new Object[]{info.getTitle(), info.getTimeout(), info.getDataSnapshot()});
        } else {
            LOGGER.warn("[easy-log][{}]--end timeout:{} exception:{}", new Object[]{info.getTitle(), info.getTimeout(), info.getException()});
        }
    }
}

