/*
 * Decompiled with CFR 0.152.
 */
package com.easycode8.easylog.core.util;

import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class SpringSpelUtils {
    private static ExpressionParser parser = new SpelExpressionParser();
    private static LocalVariableTableParameterNameDiscoverer discoverer = new LocalVariableTableParameterNameDiscoverer();

    public static String parse(Method method, Object[] args, String template) {
        if (StringUtils.isEmpty((Object)template)) {
            return "";
        }
        String[] params = discoverer.getParameterNames(method);
        StandardEvaluationContext context = new StandardEvaluationContext();
        for (int len = 0; len < params.length; ++len) {
            context.setVariable(params[len], args[len]);
        }
        Expression expression = parser.parseExpression(template);
        String spelDescription = (String)expression.getValue((EvaluationContext)context, String.class);
        return spelDescription;
    }

    public static Object getSessionAttribute(String attributeName, String expression) {
        if (RequestContextHolder.getRequestAttributes() == null) {
            return null;
        }
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        HttpSession session = request.getSession();
        Object attributeValue = session.getAttribute(attributeName);
        if (attributeValue == null) {
            return null;
        }
        return parser.parseExpression(expression).getValue(attributeValue);
    }
}

