/*
 * Decompiled with CFR 0.152.
 */
package com.easycode8.easylog.core.monitor;

import com.easycode8.easylog.core.annotation.EasyLogProperties;
import com.easycode8.easylog.core.aop.interceptor.TimingLogAttributeSourcePointcut;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.availability.AvailabilityChangeEvent;
import org.springframework.boot.availability.ReadinessState;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;

public class EasyLogApplicationInfoPrinter
implements ApplicationListener<AvailabilityChangeEvent<ReadinessState>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EasyLogApplicationInfoPrinter.class);
    @Value(value="${easy-log.monitor.printServerInfo:true}")
    private boolean printServerInfo;
    private EasyLogProperties easyLogProperties;

    public void onApplicationEvent(AvailabilityChangeEvent<ReadinessState> availabilityChangeEvent) {
        if (availabilityChangeEvent.getState() == ReadinessState.ACCEPTING_TRAFFIC && this.printServerInfo) {
            try {
                ConfigurableApplicationContext context = (ConfigurableApplicationContext)availabilityChangeEvent.getSource();
                ConfigurableEnvironment environment = context.getEnvironment();
                String serverPort = EasyLogApplicationInfoPrinter.getApplicationServerPort((Environment)environment);
                LOGGER.info("==============================");
                LOGGER.info("[easy-log] aop\u626b\u63cf\u52a0\u8f7d\u8017\u65f6:{}\u6beb\u79d2", (Object)TimingLogAttributeSourcePointcut.getTotalAopMatchesTime());
                MemoryUsage heapUsage = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
                LOGGER.info("[easy-log] JVM\u5806\u5185\u5b58\u4f7f\u7528\u60c5\u51b5: \u521d\u59cb\u503c={}MB, \u6700\u5927\u503c={}MB, \u5f53\u524d\u503c={}MB", new Object[]{heapUsage.getInit() / 1024L / 1024L, heapUsage.getMax() / 1024L / 1024L, heapUsage.getUsed() / 1024L / 1024L});
                LOGGER.info("[easy-log] \u9879\u76ee\u542f\u52a8\u7aef\u53e3: {},\u9879\u76ee\u542f\u52a8\u8017\u65f6: {} \u79d2", (Object)serverPort, (Object)Float.valueOf((float)ManagementFactory.getRuntimeMXBean().getUptime() / 1000.0f));
                LOGGER.info("==============================");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static String getApplicationServerPort(Environment environment) {
        return Optional.ofNullable(environment.getProperty("local.server.port")).orElse(environment.getProperty("server.port"));
    }
}

