/*
 * Decompiled with CFR 0.152.
 */
package com.easycode8.easylog.core.cache;

import com.alibaba.fastjson.JSON;
import com.easycode8.easylog.core.annotation.EasyLogProperties;
import com.easycode8.easylog.core.aop.interceptor.DefaultLogAttribute;
import com.easycode8.easylog.core.aop.interceptor.LogAttribute;
import com.easycode8.easylog.core.cache.LogAttributeCache;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.RedisTemplate;

public class LogAttributeRedisCache
implements LogAttributeCache,
MessageListener,
ApplicationRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogAttributeRedisCache.class);
    private ConcurrentHashMap<String, DefaultLogAttribute> cacheMap = new ConcurrentHashMap();
    private final RedisTemplate redisTemplate;
    private final EasyLogProperties easyLogProperties;
    private Boolean inited = false;
    private String hashKey;

    public LogAttributeRedisCache(RedisTemplate redisTemplate, EasyLogProperties easyLogProperties) {
        this.redisTemplate = redisTemplate;
        this.easyLogProperties = easyLogProperties;
        this.hashKey = easyLogProperties.getCache().getKeyPrefix();
    }

    @Override
    public boolean containsKey(String key) {
        return this.cacheMap.containsKey(key);
    }

    @Override
    public void put(String key, LogAttribute attribute) {
        if (this.inited.booleanValue()) {
            this.pushToHash(key, attribute);
            this.redisTemplate.convertAndSend("easy-log.update", (Object)((DefaultLogAttribute)attribute));
        } else {
            this.cacheMap.put(key, (DefaultLogAttribute)attribute);
        }
    }

    @Override
    public LogAttribute get(String key) {
        return this.cacheMap.get(key);
    }

    @Override
    public Map<String, LogAttribute> getAll() {
        Map<String, LogAttribute> resultMap = this.getAllFromHash().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> (DefaultLogAttribute)entry.getValue()));
        return resultMap;
    }

    public void run(ApplicationArguments args) throws Exception {
        this.inited = true;
        this.initConfig();
    }

    public void onMessage(Message message, byte[] pattern) {
        String channel = new String(message.getChannel());
        String body = new String(message.getBody());
        DefaultLogAttribute defaultLogAttribute = (DefaultLogAttribute)JSON.parseObject((String)body, DefaultLogAttribute.class);
        LOGGER.info("[easy-log] cache receive redis message. channel[{}] content:{}", (Object)channel, (Object)body);
        this.cacheMap.put(defaultLogAttribute.title(), defaultLogAttribute);
    }

    private void initConfig() {
        Map<String, DefaultLogAttribute> redisCacheMap = this.getAllFromHash();
        if (redisCacheMap == null || redisCacheMap.isEmpty()) {
            LOGGER.info("[easy-log]\u901a\u8fc7redis\u521d\u59cb\u5316\u65e5\u5fd7\u5c5e\u6027--\u5f00\u59cb cache:{}", this.cacheMap);
            this.pushAllToHash(this.cacheMap);
            LOGGER.info("[easy-log]\u901a\u8fc7redis\u521d\u59cb\u5316\u65e5\u5fd7\u5c5e\u6027---\u6210\u529f");
        } else if (this.easyLogProperties.getCache().getDropFirst().booleanValue()) {
            LOGGER.warn("[easy-log]\u4f7f\u7528\u672c\u5730\u914d\u7f6e\u5f3a\u5236\u521d\u59cb\u5316\u96c6\u7fa4\u914d\u7f6e--\u5f00\u59cb");
            this.pushAllToHash(this.cacheMap);
            LOGGER.warn("[easy-log]\u4f7f\u7528\u672c\u5730\u914d\u7f6e\u5f3a\u5236\u521d\u59cb\u5316\u96c6\u7fa4\u914d\u7f6e--\u6210\u529f");
        } else {
            LOGGER.info("[easy-log]\u901a\u8fc7redis\u5237\u65b0\u6570\u636e\u6e90\u914d\u7f6e--\u5f00\u59cb");
            this.reloadLocalConfig();
            LOGGER.info("[easy-log]\u901a\u8fc7redis\u5237\u65b0\u6570\u636e\u6e90\u914d\u7f6e--\u6210\u529f");
        }
    }

    protected void reloadLocalConfig() {
        Map<String, DefaultLogAttribute> redisCacheMap = this.getAllFromHash();
        List waitDeleteSet = (List)CollectionUtils.subtract(redisCacheMap.keySet(), new HashSet(this.cacheMap.keySet()));
        for (String key : waitDeleteSet) {
            LOGGER.info("[easy-log] redis remove cache key:{}", (Object)key);
            this.deleteFromHash(key);
            redisCacheMap.remove(key);
        }
        this.cacheMap.putAll(redisCacheMap);
        List waitAddSet = (List)CollectionUtils.subtract(new HashSet(this.cacheMap.keySet()), redisCacheMap.keySet());
        for (String key : waitAddSet) {
            LOGGER.info("[easy-log] redis push cache key:{}", (Object)key);
            this.pushToHash(key, this.cacheMap.get(key));
        }
    }

    public void pushToHash(String key, Object value) {
        HashOperations hashOperations = this.redisTemplate.opsForHash();
        hashOperations.put((Object)this.hashKey, (Object)key, value);
    }

    public void pushAllToHash(Map<String, DefaultLogAttribute> map) {
        HashOperations hashOperations = this.redisTemplate.opsForHash();
        hashOperations.putAll((Object)this.hashKey, map);
    }

    public Object getFromHash(String key) {
        HashOperations hashOperations = this.redisTemplate.opsForHash();
        return hashOperations.get((Object)this.hashKey, (Object)key);
    }

    public Map<String, DefaultLogAttribute> getAllFromHash() {
        HashOperations hashOperations = this.redisTemplate.opsForHash();
        return hashOperations.entries((Object)this.hashKey);
    }

    public void deleteFromHash(String key) {
        HashOperations hashOperations = this.redisTemplate.opsForHash();
        hashOperations.delete((Object)this.hashKey, new Object[]{key});
    }
}

