/*
 * Decompiled with CFR 0.152.
 */
package com.easycode8.easylog.core.cache;

import com.easycode8.easylog.core.annotation.EasyLogProperties;
import com.easycode8.easylog.core.cache.LogAttributeCache;
import com.easycode8.easylog.core.cache.LogAttributeMemoryCache;
import com.easycode8.easylog.core.cache.LogAttributeRedisCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.listener.PatternTopic;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.listener.Topic;

public abstract class LogAttributeCacheConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogAttributeCacheConfiguration.class);

    public static class LocalCacheConfiguration {
        @Bean
        @ConditionalOnMissingBean(value={LogAttributeCache.class})
        public LogAttributeCache logAttributeCache() {
            LOGGER.info("[easy-log]\u65e5\u5fd7\u5c5e\u6027--\u4f7f\u7528\u672c\u5730\u5185\u5b58\u7f13\u5b58");
            return new LogAttributeMemoryCache();
        }
    }

    @ConditionalOnProperty(value={"spring.easy-log.cache.redis.enabled"}, havingValue="true", matchIfMissing=true)
    @ConditionalOnClass(value={RedisTemplate.class})
    public static class RedisCacheConfiguration {
        @Bean
        @ConditionalOnBean(value={RedisTemplate.class})
        @ConditionalOnMissingBean(value={LogAttributeCache.class})
        public LogAttributeCache logAttributeCache(@Qualifier(value="redisTemplate") RedisTemplate redisTemplate, EasyLogProperties easyLogProperties) {
            LOGGER.info("[easy-log]\u542f\u52a8redis\u7f13\u5b58\u65e5\u5fd7\u5c5e\u6027(spring.easy-log.cache.redis.enabled \u53ef\u63a7\u5236\u5173\u95ed)");
            return new LogAttributeRedisCache(redisTemplate, easyLogProperties);
        }

        @Bean
        public RedisMessageListenerContainer redisMessageListenerContainer(RedisConnectionFactory connectionFactory, LogAttributeRedisCache messageListener) {
            RedisMessageListenerContainer container = new RedisMessageListenerContainer();
            container.setConnectionFactory(connectionFactory);
            container.addMessageListener((MessageListener)messageListener, (Topic)new PatternTopic("easy-log.*"));
            return container;
        }
    }
}

