/*
 * Decompiled with CFR 0.152.
 */
package com.easycode8.easylog.core.aop.interceptor;

import com.easycode8.easylog.core.adapter.LogAttributeMappingAdapter;
import com.easycode8.easylog.core.annotation.EasyLog;
import com.easycode8.easylog.core.annotation.EasyLogProperties;
import com.easycode8.easylog.core.annotation.Tag;
import com.easycode8.easylog.core.aop.interceptor.AbstractCacheLogAttributeSource;
import com.easycode8.easylog.core.aop.interceptor.DefaultLogAttribute;
import com.easycode8.easylog.core.aop.interceptor.LogAttribute;
import com.easycode8.easylog.core.cache.LogAttributeCache;
import com.easycode8.easylog.core.util.LogUtils;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class AnnotationLogAttributeSource
extends AbstractCacheLogAttributeSource {
    private final List<LogAttributeMappingAdapter> mappingAdapters;

    public AnnotationLogAttributeSource(LogAttributeCache logAttributeCache, EasyLogProperties easyLogProperties, List<LogAttributeMappingAdapter> mappingAdapters) {
        super(logAttributeCache, easyLogProperties);
        this.mappingAdapters = mappingAdapters;
    }

    @Override
    public LogAttribute doGetLogAttribute(Method method, Class<?> targetClass) {
        EasyLog easyLog = method.getAnnotation(EasyLog.class);
        if (easyLog != null) {
            String title;
            String string = title = StringUtils.isEmpty((Object)easyLog.title()) ? easyLog.value() : easyLog.title();
            if (StringUtils.isEmpty((Object)title)) {
                title = LogUtils.createDefaultTitle(method, targetClass);
            }
            Tag[] tags = easyLog.tags();
            Map<String, String> tagMap = null;
            if (tags != null) {
                tagMap = Arrays.stream(tags).filter(item -> StringUtils.hasText((String)item.key())).map(p -> new AbstractMap.SimpleEntry<String, String>(p.key(), p.value())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            }
            boolean async = false;
            switch (easyLog.handleMode()) {
                case GLOBAL: {
                    async = this.easyLogProperties.getAsync();
                    break;
                }
                case ASYNC: {
                    async = true;
                    break;
                }
                case SYNC: {
                    async = false;
                }
            }
            return DefaultLogAttribute.builder().title(title).handler(easyLog.handler()).template(easyLog.template()).operator(easyLog.operator()).async(async).tags(tagMap).build();
        }
        if (CollectionUtils.isEmpty(this.mappingAdapters)) {
            return null;
        }
        for (LogAttributeMappingAdapter mappingAdapter : this.mappingAdapters) {
            LogAttribute logAttribute = mappingAdapter.getLogAttribute(method, targetClass);
            if (logAttribute == null) continue;
            return logAttribute;
        }
        return null;
    }
}

