/*
 * Decompiled with CFR 0.152.
 */
package com.easycode8.easylog.core.aop.interceptor;

import com.easycode8.easylog.core.annotation.EasyLogProperties;
import com.easycode8.easylog.core.aop.interceptor.LogAttribute;
import com.easycode8.easylog.core.aop.interceptor.LogAttributeSource;
import com.easycode8.easylog.core.cache.LogAttributeCache;
import com.easycode8.easylog.core.util.LogUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.SpringBootApplication;

public abstract class AbstractCacheLogAttributeSource
implements LogAttributeSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractCacheLogAttributeSource.class);
    private final LogAttributeCache logAttributeCache;
    protected EasyLogProperties easyLogProperties;

    protected AbstractCacheLogAttributeSource(LogAttributeCache logAttributeCache, EasyLogProperties easyLogProperties) {
        this.logAttributeCache = logAttributeCache;
        this.easyLogProperties = easyLogProperties;
    }

    @Override
    public LogAttribute getLogAttribute(Method method, Class<?> targetClass) {
        String key;
        if (Proxy.isProxyClass(targetClass)) {
            String className = ((Class)targetClass.getGenericInterfaces()[0]).getName();
            if (!this.matches(className, this.easyLogProperties.getScanPackages())) {
                return null;
            }
            key = LogUtils.createDefaultTitle(method, (Class)targetClass.getGenericInterfaces()[0], false);
        } else {
            if (!this.matches(targetClass.getName(), this.easyLogProperties.getScanPackages())) {
                return null;
            }
            if (targetClass.getAnnotation(SpringBootApplication.class) != null) {
                return null;
            }
            key = LogUtils.createDefaultTitle(method, targetClass, false);
        }
        key = !this.easyLogProperties.getCache().getKeyPrefix().endsWith(":") ? this.easyLogProperties.getCache().getKeyPrefix() + ":" + key : this.easyLogProperties.getCache().getKeyPrefix() + key;
        if (this.logAttributeCache.containsKey(key)) {
            return this.logAttributeCache.get(key);
        }
        LogAttribute attribute = this.doGetLogAttribute(method, targetClass);
        if (attribute != null) {
            this.logAttributeCache.put(key, attribute);
        }
        return attribute;
    }

    public abstract LogAttribute doGetLogAttribute(Method var1, Class<?> var2);

    public Map<String, LogAttribute> getCacheMap() {
        return this.logAttributeCache.getAll();
    }

    public void updateCache(String key, LogAttribute logAttribute) {
        this.logAttributeCache.put(key, logAttribute);
    }

    private boolean matches(String className, Set<String> basePackages) {
        if (basePackages == null || basePackages.isEmpty()) {
            return true;
        }
        boolean matches = basePackages.stream().anyMatch(item -> className.startsWith((String)item));
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("[ease-log] \u7c7b:{} AOP\u589e\u5f3a:{} \u5339\u914d\u524d\u7f00:{}", new Object[]{className, matches, basePackages});
        }
        return matches;
    }
}

