/*
 * Decompiled with CFR 0.152.
 */
package com.easycode8.easylog.core.annotation;

import com.easycode8.easylog.core.adapter.LogAttributeMappingAdapter;
import com.easycode8.easylog.core.annotation.EasyLogProperties;
import com.easycode8.easylog.core.aop.BeanFactoryLogAttributeSourceAdvisor;
import com.easycode8.easylog.core.aop.interceptor.AnnotationLogAttributeSource;
import com.easycode8.easylog.core.aop.interceptor.LogAttributeSource;
import com.easycode8.easylog.core.aop.interceptor.LogMethodInterceptor;
import com.easycode8.easylog.core.cache.LogAttributeCache;
import com.easycode8.easylog.core.cache.LogAttributeCacheConfiguration;
import com.easycode8.easylog.core.handler.DefaultLogHandler;
import com.easycode8.easylog.core.handler.LogDataHandler;
import com.easycode8.easylog.core.monitor.EasyLogApplicationInfoPrinter;
import com.easycode8.easylog.core.provider.OperatorProvider;
import com.easycode8.easylog.core.provider.SessionOperatorProvider;
import com.easycode8.easylog.core.trace.LogTracer;
import com.easycode8.easylog.core.trace.NoneLogTracer;
import java.util.List;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import org.aopalliance.aop.Advice;
import org.springframework.aop.Advisor;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.task.TaskDecorator;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@Configuration
@EnableConfigurationProperties(value={EasyLogProperties.class})
public class EasyLogConfiguration {
    @Bean
    public Advisor easyLogStaticMethodMatcherPointcutAdvisor(LogAttributeSource logAttributeSource, LogMethodInterceptor logMethodInterceptor, EasyLogProperties easyLogProperties) {
        BeanFactoryLogAttributeSourceAdvisor advisor = new BeanFactoryLogAttributeSourceAdvisor();
        advisor.setLogAttributeSource(logAttributeSource);
        advisor.setAdvice((Advice)logMethodInterceptor);
        if (easyLogProperties.getAspectOrder() != null) {
            advisor.setOrder(easyLogProperties.getAspectOrder());
        }
        return advisor;
    }

    @Bean
    public LogMethodInterceptor easyLogMethodInterceptor(LogAttributeSource logAttributeSource, @Qualifier(value="easyLogThreadPoolTaskExecutor") ThreadPoolTaskExecutor taskExecutor, @Qualifier(value="easyLogDataHandler") LogDataHandler logDataHandler, ObjectProvider<OperatorProvider> operatorProvider, ObjectProvider<LogTracer> tracerObjectProvider) {
        LogMethodInterceptor logMethodInterceptor = new LogMethodInterceptor();
        logMethodInterceptor.setLogAttributeSource(logAttributeSource);
        logMethodInterceptor.setThreadPoolTaskExecutor(taskExecutor);
        logMethodInterceptor.setLogDataHandler(logDataHandler);
        logMethodInterceptor.setOperatorProvider((OperatorProvider)operatorProvider.getIfAvailable());
        LogTracer logTracer = (LogTracer)tracerObjectProvider.getIfAvailable();
        if (logTracer == null) {
            logTracer = new NoneLogTracer();
        }
        logMethodInterceptor.setLogTracer(logTracer);
        return logMethodInterceptor;
    }

    @Bean
    @ConditionalOnMissingBean
    public LogAttributeSource logAttributeSource(LogAttributeCache logAttributeCache, EasyLogProperties easyLogProperties, List<LogAttributeMappingAdapter> mappingAdapters) {
        return new AnnotationLogAttributeSource(logAttributeCache, easyLogProperties, mappingAdapters);
    }

    @Bean
    @ConditionalOnMissingBean(name={"easyLogDataHandler"})
    public LogDataHandler easyLogDataHandler() {
        return new DefaultLogHandler();
    }

    @Bean
    @ConditionalOnMissingBean
    public OperatorProvider easyLogOperatorProvider(EasyLogProperties easyLogProperties) {
        return new SessionOperatorProvider(easyLogProperties);
    }

    @Bean
    @ConditionalOnMissingBean(name={"easyLogThreadPoolTaskExecutor"})
    public ThreadPoolTaskExecutor easyLogThreadPoolTaskExecutor(EasyLogProperties easyLogProperties, ObjectProvider<TaskDecorator> objectProvider) {
        EasyLogProperties.Task async = easyLogProperties.getTask();
        ThreadPoolTaskExecutor taskExecutor = new ThreadPoolTaskExecutor();
        taskExecutor.setCorePoolSize(async.getCorePoolSize().intValue());
        taskExecutor.setMaxPoolSize(async.getMaxPoolSize().intValue());
        taskExecutor.setQueueCapacity(async.getQueueCapacity().intValue());
        taskExecutor.setKeepAliveSeconds(async.getKeepAliveSeconds().intValue());
        taskExecutor.setThreadNamePrefix(async.getThreadNamePrefix());
        taskExecutor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
        taskExecutor.setTaskDecorator((TaskDecorator)objectProvider.getIfAvailable());
        taskExecutor.initialize();
        return taskExecutor;
    }

    @Bean
    public EasyLogApplicationInfoPrinter easyLogApplicationInfoPrinter() {
        return new EasyLogApplicationInfoPrinter();
    }

    @Configuration
    @ConditionalOnMissingBean(value={LogAttributeCache.class})
    @Import(value={LogAttributeCacheConfiguration.RedisCacheConfiguration.class, LogAttributeCacheConfiguration.LocalCacheConfiguration.class})
    public static class ChooseLogAttributeCacheConfiguration {
    }
}

