/*
 * Decompiled with CFR 0.152.
 */
package com.easycode8.easylog.core;

import org.slf4j.Logger;
import org.slf4j.helpers.MessageFormatter;
import org.springframework.util.StopWatch;

public class LogStopWatch {
    private Logger logger;
    private StopWatch stopWatch;

    public LogStopWatch(Logger logger, String stopWatchName) {
        this.logger = logger;
        this.stopWatch = new StopWatch(stopWatchName);
    }

    public LogStopWatch stop() {
        if (this.logger.isDebugEnabled()) {
            this.stopWatch.stop();
        }
        return this;
    }

    public void start(String message, String ... variable) {
        if (this.logger.isDebugEnabled()) {
            this.stopWatch.start(MessageFormatter.arrayFormat((String)message, (Object[])variable).getMessage());
        }
    }

    public void start(String taskName) {
        if (this.logger.isDebugEnabled()) {
            this.stopWatch.start(taskName);
        }
    }

    public void showDetail() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(this.stopWatch.prettyPrint());
        }
    }
}

