/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.monitoring.v1.Rule;
import io.fabric8.openshift.api.model.monitoring.v1.RuleBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.RuleFluentImpl;
import io.fabric8.openshift.api.model.monitoring.v1.RuleGroup;
import io.fabric8.openshift.api.model.monitoring.v1.RuleGroupFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class RuleGroupFluentImpl<A extends RuleGroupFluent<A>>
extends BaseFluent<A>
implements RuleGroupFluent<A> {
    private String interval;
    private String name;
    private String partialResponseStrategy;
    private List<RuleBuilder> rules = new ArrayList<RuleBuilder>();
    private Map<String, Object> additionalProperties;

    public RuleGroupFluentImpl() {
    }

    public RuleGroupFluentImpl(RuleGroup instance) {
        this.withInterval(instance.getInterval());
        this.withName(instance.getName());
        this.withPartialResponseStrategy(instance.getPartialResponseStrategy());
        this.withRules(instance.getRules());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public String getInterval() {
        return this.interval;
    }

    @Override
    public A withInterval(String interval) {
        this.interval = interval;
        return (A)this;
    }

    @Override
    public Boolean hasInterval() {
        return this.interval != null;
    }

    @Override
    @Deprecated
    public A withNewInterval(String arg0) {
        return this.withInterval(new String(arg0));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    @Deprecated
    public A withNewName(String arg0) {
        return this.withName(new String(arg0));
    }

    @Override
    public String getPartialResponseStrategy() {
        return this.partialResponseStrategy;
    }

    @Override
    public A withPartialResponseStrategy(String partialResponseStrategy) {
        this.partialResponseStrategy = partialResponseStrategy;
        return (A)this;
    }

    @Override
    public Boolean hasPartialResponseStrategy() {
        return this.partialResponseStrategy != null;
    }

    @Override
    @Deprecated
    public A withNewPartialResponseStrategy(String arg0) {
        return this.withPartialResponseStrategy(new String(arg0));
    }

    @Override
    public A addToRules(Integer index, Rule item) {
        if (this.rules == null) {
            this.rules = new ArrayList<RuleBuilder>();
        }
        RuleBuilder builder = new RuleBuilder(item);
        this._visitables.get((Object)"rules").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"rules").size(), builder);
        this.rules.add(index >= 0 ? index.intValue() : this.rules.size(), builder);
        return (A)this;
    }

    @Override
    public A setToRules(Integer index, Rule item) {
        if (this.rules == null) {
            this.rules = new ArrayList<RuleBuilder>();
        }
        RuleBuilder builder = new RuleBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"rules").size()) {
            this._visitables.get((Object)"rules").add(builder);
        } else {
            this._visitables.get((Object)"rules").set(index, builder);
        }
        if (index < 0 || index >= this.rules.size()) {
            this.rules.add(builder);
        } else {
            this.rules.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToRules(Rule ... items) {
        if (this.rules == null) {
            this.rules = new ArrayList<RuleBuilder>();
        }
        for (Rule item : items) {
            RuleBuilder builder = new RuleBuilder(item);
            this._visitables.get((Object)"rules").add(builder);
            this.rules.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToRules(Collection<Rule> items) {
        if (this.rules == null) {
            this.rules = new ArrayList<RuleBuilder>();
        }
        for (Rule item : items) {
            RuleBuilder builder = new RuleBuilder(item);
            this._visitables.get((Object)"rules").add(builder);
            this.rules.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromRules(Rule ... items) {
        for (Rule item : items) {
            RuleBuilder builder = new RuleBuilder(item);
            this._visitables.get((Object)"rules").remove(builder);
            if (this.rules == null) continue;
            this.rules.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromRules(Collection<Rule> items) {
        for (Rule item : items) {
            RuleBuilder builder = new RuleBuilder(item);
            this._visitables.get((Object)"rules").remove(builder);
            if (this.rules == null) continue;
            this.rules.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromRules(Predicate<RuleBuilder> predicate) {
        if (this.rules == null) {
            return (A)this;
        }
        Iterator<RuleBuilder> each = this.rules.iterator();
        List visitables = this._visitables.get((Object)"rules");
        while (each.hasNext()) {
            RuleBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Rule> getRules() {
        return RuleGroupFluentImpl.build(this.rules);
    }

    @Override
    public List<Rule> buildRules() {
        return RuleGroupFluentImpl.build(this.rules);
    }

    @Override
    public Rule buildRule(Integer index) {
        return this.rules.get(index).build();
    }

    @Override
    public Rule buildFirstRule() {
        return this.rules.get(0).build();
    }

    @Override
    public Rule buildLastRule() {
        return this.rules.get(this.rules.size() - 1).build();
    }

    @Override
    public Rule buildMatchingRule(Predicate<RuleBuilder> predicate) {
        for (RuleBuilder item : this.rules) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingRule(Predicate<RuleBuilder> predicate) {
        for (RuleBuilder item : this.rules) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withRules(List<Rule> rules) {
        if (this.rules != null) {
            this._visitables.get((Object)"rules").removeAll(this.rules);
        }
        if (rules != null) {
            this.rules = new ArrayList<RuleBuilder>();
            for (Rule item : rules) {
                this.addToRules(item);
            }
        } else {
            this.rules = null;
        }
        return (A)this;
    }

    @Override
    public A withRules(Rule ... rules) {
        if (this.rules != null) {
            this.rules.clear();
        }
        if (rules != null) {
            for (Rule item : rules) {
                this.addToRules(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasRules() {
        return this.rules != null && !this.rules.isEmpty();
    }

    @Override
    public RuleGroupFluent.RulesNested<A> addNewRule() {
        return new RulesNestedImpl();
    }

    @Override
    public RuleGroupFluent.RulesNested<A> addNewRuleLike(Rule item) {
        return new RulesNestedImpl(-1, item);
    }

    @Override
    public RuleGroupFluent.RulesNested<A> setNewRuleLike(Integer index, Rule item) {
        return new RulesNestedImpl(index, item);
    }

    @Override
    public RuleGroupFluent.RulesNested<A> editRule(Integer index) {
        if (this.rules.size() <= index) {
            throw new RuntimeException("Can't edit rules. Index exceeds size.");
        }
        return this.setNewRuleLike(index, this.buildRule(index));
    }

    @Override
    public RuleGroupFluent.RulesNested<A> editFirstRule() {
        if (this.rules.size() == 0) {
            throw new RuntimeException("Can't edit first rules. The list is empty.");
        }
        return this.setNewRuleLike(0, this.buildRule(0));
    }

    @Override
    public RuleGroupFluent.RulesNested<A> editLastRule() {
        int index = this.rules.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last rules. The list is empty.");
        }
        return this.setNewRuleLike(index, this.buildRule(index));
    }

    @Override
    public RuleGroupFluent.RulesNested<A> editMatchingRule(Predicate<RuleBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.rules.size(); ++i) {
            if (!predicate.test(this.rules.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching rules. No match found.");
        }
        return this.setNewRuleLike(index, this.buildRule(index));
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RuleGroupFluentImpl that = (RuleGroupFluentImpl)o;
        if (this.interval != null ? !this.interval.equals(that.interval) : that.interval != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.partialResponseStrategy != null ? !this.partialResponseStrategy.equals(that.partialResponseStrategy) : that.partialResponseStrategy != null) {
            return false;
        }
        if (this.rules != null ? !this.rules.equals(that.rules) : that.rules != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.interval, this.name, this.partialResponseStrategy, this.rules, this.additionalProperties, super.hashCode());
    }

    public class RulesNestedImpl<N>
    extends RuleFluentImpl<RuleGroupFluent.RulesNested<N>>
    implements RuleGroupFluent.RulesNested<N>,
    Nested<N> {
        RuleBuilder builder;
        Integer index;

        RulesNestedImpl(Integer index, Rule item) {
            this.index = index;
            this.builder = new RuleBuilder(this, item);
        }

        RulesNestedImpl() {
            this.index = -1;
            this.builder = new RuleBuilder(this);
        }

        @Override
        public N and() {
            return (N)RuleGroupFluentImpl.this.setToRules(this.index, this.builder.build());
        }

        @Override
        public N endRule() {
            return this.and();
        }
    }
}

