/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ClientIPConfig;
import io.fabric8.kubernetes.api.model.ClientIPConfigBuilder;
import io.fabric8.kubernetes.api.model.ClientIPConfigFluent;
import io.fabric8.kubernetes.api.model.SessionAffinityConfig;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class SessionAffinityConfigFluent<A extends SessionAffinityConfigFluent<A>>
extends BaseFluent<A> {
    private ClientIPConfigBuilder clientIP;
    private Map<String, Object> additionalProperties;

    public SessionAffinityConfigFluent() {
    }

    public SessionAffinityConfigFluent(SessionAffinityConfig instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(SessionAffinityConfig instance) {
        SessionAffinityConfig sessionAffinityConfig = instance = instance != null ? instance : new SessionAffinityConfig();
        if (instance != null) {
            this.withClientIP(instance.getClientIP());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ClientIPConfig buildClientIP() {
        return this.clientIP != null ? this.clientIP.build() : null;
    }

    public A withClientIP(ClientIPConfig clientIP) {
        this._visitables.remove((Object)"clientIP");
        if (clientIP != null) {
            this.clientIP = new ClientIPConfigBuilder(clientIP);
            this._visitables.get((Object)"clientIP").add(this.clientIP);
        } else {
            this.clientIP = null;
            this._visitables.get((Object)"clientIP").remove((Object)this.clientIP);
        }
        return (A)((Object)this);
    }

    public boolean hasClientIP() {
        return this.clientIP != null;
    }

    public A withNewClientIP(Integer timeoutSeconds) {
        return this.withClientIP(new ClientIPConfig(timeoutSeconds));
    }

    public ClientIPNested<A> withNewClientIP() {
        return new ClientIPNested(null);
    }

    public ClientIPNested<A> withNewClientIPLike(ClientIPConfig item) {
        return new ClientIPNested(item);
    }

    public ClientIPNested<A> editClientIP() {
        return this.withNewClientIPLike(Optional.ofNullable(this.buildClientIP()).orElse(null));
    }

    public ClientIPNested<A> editOrNewClientIP() {
        return this.withNewClientIPLike(Optional.ofNullable(this.buildClientIP()).orElse(new ClientIPConfigBuilder().build()));
    }

    public ClientIPNested<A> editOrNewClientIPLike(ClientIPConfig item) {
        return this.withNewClientIPLike(Optional.ofNullable(this.buildClientIP()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SessionAffinityConfigFluent that = (SessionAffinityConfigFluent)((Object)o);
        if (!Objects.equals((Object)this.clientIP, (Object)that.clientIP)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.clientIP, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.clientIP != null) {
            sb.append("clientIP:");
            sb.append((Object)((Object)this.clientIP) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ClientIPNested<N>
    extends ClientIPConfigFluent<ClientIPNested<N>>
    implements Nested<N> {
        ClientIPConfigBuilder builder;

        ClientIPNested(ClientIPConfig item) {
            this.builder = new ClientIPConfigBuilder(this, item);
        }

        public N and() {
            return (N)SessionAffinityConfigFluent.this.withClientIP(this.builder.build());
        }

        public N endClientIP() {
            return this.and();
        }
    }
}

