/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.apps;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.apps.DaemonSetSpec;
import io.fabric8.kubernetes.api.model.apps.DaemonSetUpdateStrategy;
import io.fabric8.kubernetes.api.model.apps.DaemonSetUpdateStrategyBuilder;
import io.fabric8.kubernetes.api.model.apps.DaemonSetUpdateStrategyFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class DaemonSetSpecFluent<A extends DaemonSetSpecFluent<A>>
extends BaseFluent<A> {
    private Integer minReadySeconds;
    private Integer revisionHistoryLimit;
    private LabelSelectorBuilder selector;
    private PodTemplateSpecBuilder template;
    private DaemonSetUpdateStrategyBuilder updateStrategy;
    private Map<String, Object> additionalProperties;

    public DaemonSetSpecFluent() {
    }

    public DaemonSetSpecFluent(DaemonSetSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(DaemonSetSpec instance) {
        DaemonSetSpec daemonSetSpec = instance = instance != null ? instance : new DaemonSetSpec();
        if (instance != null) {
            this.withMinReadySeconds(instance.getMinReadySeconds());
            this.withRevisionHistoryLimit(instance.getRevisionHistoryLimit());
            this.withSelector(instance.getSelector());
            this.withTemplate(instance.getTemplate());
            this.withUpdateStrategy(instance.getUpdateStrategy());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public Integer getMinReadySeconds() {
        return this.minReadySeconds;
    }

    public A withMinReadySeconds(Integer minReadySeconds) {
        this.minReadySeconds = minReadySeconds;
        return (A)((Object)this);
    }

    public boolean hasMinReadySeconds() {
        return this.minReadySeconds != null;
    }

    public Integer getRevisionHistoryLimit() {
        return this.revisionHistoryLimit;
    }

    public A withRevisionHistoryLimit(Integer revisionHistoryLimit) {
        this.revisionHistoryLimit = revisionHistoryLimit;
        return (A)((Object)this);
    }

    public boolean hasRevisionHistoryLimit() {
        return this.revisionHistoryLimit != null;
    }

    public LabelSelector buildSelector() {
        return this.selector != null ? this.selector.build() : null;
    }

    public A withSelector(LabelSelector selector) {
        this._visitables.remove((Object)"selector");
        if (selector != null) {
            this.selector = new LabelSelectorBuilder(selector);
            this._visitables.get((Object)"selector").add(this.selector);
        } else {
            this.selector = null;
            this._visitables.get((Object)"selector").remove(this.selector);
        }
        return (A)((Object)this);
    }

    public boolean hasSelector() {
        return this.selector != null;
    }

    public SelectorNested<A> withNewSelector() {
        return new SelectorNested(null);
    }

    public SelectorNested<A> withNewSelectorLike(LabelSelector item) {
        return new SelectorNested(item);
    }

    public SelectorNested<A> editSelector() {
        return this.withNewSelectorLike(Optional.ofNullable(this.buildSelector()).orElse(null));
    }

    public SelectorNested<A> editOrNewSelector() {
        return this.withNewSelectorLike(Optional.ofNullable(this.buildSelector()).orElse(new LabelSelectorBuilder().build()));
    }

    public SelectorNested<A> editOrNewSelectorLike(LabelSelector item) {
        return this.withNewSelectorLike(Optional.ofNullable(this.buildSelector()).orElse(item));
    }

    public PodTemplateSpec buildTemplate() {
        return this.template != null ? this.template.build() : null;
    }

    public A withTemplate(PodTemplateSpec template) {
        this._visitables.remove((Object)"template");
        if (template != null) {
            this.template = new PodTemplateSpecBuilder(template);
            this._visitables.get((Object)"template").add(this.template);
        } else {
            this.template = null;
            this._visitables.get((Object)"template").remove(this.template);
        }
        return (A)((Object)this);
    }

    public boolean hasTemplate() {
        return this.template != null;
    }

    public TemplateNested<A> withNewTemplate() {
        return new TemplateNested(null);
    }

    public TemplateNested<A> withNewTemplateLike(PodTemplateSpec item) {
        return new TemplateNested(item);
    }

    public TemplateNested<A> editTemplate() {
        return this.withNewTemplateLike(Optional.ofNullable(this.buildTemplate()).orElse(null));
    }

    public TemplateNested<A> editOrNewTemplate() {
        return this.withNewTemplateLike(Optional.ofNullable(this.buildTemplate()).orElse(new PodTemplateSpecBuilder().build()));
    }

    public TemplateNested<A> editOrNewTemplateLike(PodTemplateSpec item) {
        return this.withNewTemplateLike(Optional.ofNullable(this.buildTemplate()).orElse(item));
    }

    public DaemonSetUpdateStrategy buildUpdateStrategy() {
        return this.updateStrategy != null ? this.updateStrategy.build() : null;
    }

    public A withUpdateStrategy(DaemonSetUpdateStrategy updateStrategy) {
        this._visitables.remove((Object)"updateStrategy");
        if (updateStrategy != null) {
            this.updateStrategy = new DaemonSetUpdateStrategyBuilder(updateStrategy);
            this._visitables.get((Object)"updateStrategy").add(this.updateStrategy);
        } else {
            this.updateStrategy = null;
            this._visitables.get((Object)"updateStrategy").remove((Object)this.updateStrategy);
        }
        return (A)((Object)this);
    }

    public boolean hasUpdateStrategy() {
        return this.updateStrategy != null;
    }

    public UpdateStrategyNested<A> withNewUpdateStrategy() {
        return new UpdateStrategyNested(null);
    }

    public UpdateStrategyNested<A> withNewUpdateStrategyLike(DaemonSetUpdateStrategy item) {
        return new UpdateStrategyNested(item);
    }

    public UpdateStrategyNested<A> editUpdateStrategy() {
        return this.withNewUpdateStrategyLike(Optional.ofNullable(this.buildUpdateStrategy()).orElse(null));
    }

    public UpdateStrategyNested<A> editOrNewUpdateStrategy() {
        return this.withNewUpdateStrategyLike(Optional.ofNullable(this.buildUpdateStrategy()).orElse(new DaemonSetUpdateStrategyBuilder().build()));
    }

    public UpdateStrategyNested<A> editOrNewUpdateStrategyLike(DaemonSetUpdateStrategy item) {
        return this.withNewUpdateStrategyLike(Optional.ofNullable(this.buildUpdateStrategy()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DaemonSetSpecFluent that = (DaemonSetSpecFluent)((Object)o);
        if (!Objects.equals(this.minReadySeconds, that.minReadySeconds)) {
            return false;
        }
        if (!Objects.equals(this.revisionHistoryLimit, that.revisionHistoryLimit)) {
            return false;
        }
        if (!Objects.equals(this.selector, that.selector)) {
            return false;
        }
        if (!Objects.equals(this.template, that.template)) {
            return false;
        }
        if (!Objects.equals((Object)this.updateStrategy, (Object)that.updateStrategy)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.minReadySeconds, this.revisionHistoryLimit, this.selector, this.template, this.updateStrategy, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.minReadySeconds != null) {
            sb.append("minReadySeconds:");
            sb.append(this.minReadySeconds + ",");
        }
        if (this.revisionHistoryLimit != null) {
            sb.append("revisionHistoryLimit:");
            sb.append(this.revisionHistoryLimit + ",");
        }
        if (this.selector != null) {
            sb.append("selector:");
            sb.append(this.selector + ",");
        }
        if (this.template != null) {
            sb.append("template:");
            sb.append(this.template + ",");
        }
        if (this.updateStrategy != null) {
            sb.append("updateStrategy:");
            sb.append((Object)((Object)this.updateStrategy) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class UpdateStrategyNested<N>
    extends DaemonSetUpdateStrategyFluent<UpdateStrategyNested<N>>
    implements Nested<N> {
        DaemonSetUpdateStrategyBuilder builder;

        UpdateStrategyNested(DaemonSetUpdateStrategy item) {
            this.builder = new DaemonSetUpdateStrategyBuilder(this, item);
        }

        public N and() {
            return (N)DaemonSetSpecFluent.this.withUpdateStrategy(this.builder.build());
        }

        public N endUpdateStrategy() {
            return this.and();
        }
    }

    public class TemplateNested<N>
    extends PodTemplateSpecFluent<TemplateNested<N>>
    implements Nested<N> {
        PodTemplateSpecBuilder builder;

        TemplateNested(PodTemplateSpec item) {
            this.builder = new PodTemplateSpecBuilder((PodTemplateSpecFluent)this, item);
        }

        public N and() {
            return (N)DaemonSetSpecFluent.this.withTemplate(this.builder.build());
        }

        public N endTemplate() {
            return this.and();
        }
    }

    public class SelectorNested<N>
    extends LabelSelectorFluent<SelectorNested<N>>
    implements Nested<N> {
        LabelSelectorBuilder builder;

        SelectorNested(LabelSelector item) {
            this.builder = new LabelSelectorBuilder((LabelSelectorFluent)this, item);
        }

        public N and() {
            return (N)DaemonSetSpecFluent.this.withSelector(this.builder.build());
        }

        public N endSelector() {
            return this.and();
        }
    }
}

