/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.service;

import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojoExecutionException;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class MojoExecutionService {
    private final MavenProject project;
    private final MavenSession session;
    private final BuildPluginManager pluginManager;

    MojoExecutionService(MavenProject project, MavenSession session, BuildPluginManager pluginManager) {
        this.project = project;
        this.session = session;
        this.pluginManager = pluginManager;
    }

    public void callPluginGoal(String fullGoal) throws MojoFailureException, MojoExecutionException {
        String[] parts = this.splitGoalSpec(fullGoal);
        Plugin plugin = this.project.getPlugin(parts[0]);
        if (plugin == null) {
            throw new MojoFailureException("No goal " + fullGoal + " found in pom.xml");
        }
        try {
            PluginDescriptor pluginDescriptor;
            MojoDescriptor mojoDescriptor;
            String goal = parts[1];
            String executionId = null;
            if (goal.indexOf(35) > -1) {
                int pos = goal.indexOf(35);
                executionId = goal.substring(pos + 1);
                goal = goal.substring(0, pos);
            }
            if ((mojoDescriptor = (pluginDescriptor = this.getPluginDescriptor(this.project, plugin)).getMojo(goal)) == null) {
                throw new MojoExecutionException("Could not find goal '" + goal + "' in " + plugin);
            }
            MojoExecution exec = this.getMojoExecution(executionId, mojoDescriptor);
            this.pluginManager.executeMojo(this.session, exec);
        }
        catch (AbstractMojoExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to execute mojo", e);
        }
    }

    private MojoExecution getMojoExecution(String executionId, MojoDescriptor mojoDescriptor) {
        if (executionId != null) {
            return new MojoExecution(mojoDescriptor, executionId);
        }
        return new MojoExecution(mojoDescriptor, this.toXpp3Dom(mojoDescriptor.getMojoConfiguration()));
    }

    PluginDescriptor getPluginDescriptor(MavenProject project, Plugin plugin) throws MojoFailureException {
        try {
            return this.pluginManager.loadPlugin(plugin, project.getRemotePluginRepositories(), this.session.getRepositorySession());
        }
        catch (Exception e) {
            throw new MojoFailureException("Could not load " + plugin, (Throwable)e);
        }
    }

    private String[] splitGoalSpec(String fullGoal) throws MojoFailureException {
        String[] parts = StringUtils.split((String)fullGoal, (String)":");
        if (parts.length != 3) {
            throw new MojoFailureException("Cannot parse " + fullGoal + " as a maven plugin goal. It must be fully qualified as in <groupId>:<artifactId>:<goal>");
        }
        return new String[]{parts[0] + ":" + parts[1], parts[2]};
    }

    private Xpp3Dom toXpp3Dom(PlexusConfiguration config) {
        Xpp3Dom result = new Xpp3Dom(config.getName());
        result.setValue(config.getValue(null));
        for (String string : config.getAttributeNames()) {
            result.setAttribute(string, config.getAttribute(string));
        }
        for (String string : config.getChildren()) {
            result.addChild(this.toXpp3Dom((PlexusConfiguration)string));
        }
        return result;
    }
}

