/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.access;

import io.fabric8.maven.docker.util.JsonFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BuildOptions {
    private Map<String, String> options;

    public BuildOptions() {
        this(new HashMap<String, String>());
    }

    public BuildOptions(Map<String, String> options) {
        this.options = options != null ? new HashMap<String, String>(options) : new HashMap();
    }

    public BuildOptions addOption(String key, String value) {
        this.options.put(key, value);
        return this;
    }

    public BuildOptions dockerfile(String name) {
        if (name != null) {
            this.options.put("dockerfile", name);
        }
        return this;
    }

    public BuildOptions forceRemove(boolean forceRm) {
        if (forceRm) {
            this.options.put("forcerm", "1");
        }
        return this;
    }

    public BuildOptions noCache(boolean noCache) {
        this.options.put("nocache", noCache ? "1" : "0");
        return this;
    }

    public BuildOptions cacheFrom(List<String> cacheFrom) {
        if (cacheFrom == null || cacheFrom.isEmpty()) {
            this.options.remove("cachefrom");
        } else {
            this.options.put("cachefrom", JsonFactory.newJsonArray(cacheFrom).toString());
        }
        return this;
    }

    public BuildOptions buildArgs(Map<String, String> buildArgs) {
        if (buildArgs != null && buildArgs.size() > 0) {
            this.options.put("buildargs", JsonFactory.newJsonObject(buildArgs).toString());
        }
        return this;
    }

    public BuildOptions network(String network) {
        if (network != null && !network.isEmpty()) {
            this.options.put("networkmode", network);
        }
        return this;
    }

    public Map<String, String> getOptions() {
        return this.options;
    }
}

