/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd.resolver;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import io.etcd.jetcd.common.exception.ErrorCode;
import io.etcd.jetcd.common.exception.EtcdExceptionFactory;
import io.grpc.Attributes;
import io.grpc.EquivalentAddressGroup;
import io.grpc.NameResolver;
import io.grpc.Status;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.SharedResourceHolder;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.concurrent.GuardedBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IPNameResolver
extends NameResolver {
    public static final String SCHEME = "ip";
    private static final Logger LOGGER = LoggerFactory.getLogger(IPNameResolver.class);
    private static final String ETCD_CLIENT_PORT = "2379";
    private final Object lock = new Object();
    private final String authority;
    private final URI targetUri;
    private final List<HostAndPort> addresses;
    private volatile boolean shutdown;
    private volatile boolean resolving;
    @GuardedBy(value="lock")
    private Executor executor;
    @GuardedBy(value="lock")
    private NameResolver.Listener listener;

    public IPNameResolver(URI targetUri) {
        this.targetUri = targetUri;
        this.authority = targetUri.getAuthority() != null ? targetUri.getAuthority() : "";
        this.addresses = Stream.of(targetUri.getPath().split(",")).map(address -> address.startsWith("/") ? address.substring(1) : address).map(HostAndPort::new).collect(Collectors.toList());
    }

    public String getServiceAuthority() {
        return this.authority;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(NameResolver.Listener listener) {
        Object object = this.lock;
        synchronized (object) {
            Preconditions.checkState((this.listener == null ? 1 : 0) != 0, (Object)"already started");
            this.executor = (Executor)SharedResourceHolder.get((SharedResourceHolder.Resource)GrpcUtil.SHARED_CHANNEL_EXECUTOR);
            this.listener = (NameResolver.Listener)Preconditions.checkNotNull((Object)listener, (Object)"listener");
            this.resolve();
        }
    }

    public final synchronized void refresh() {
        this.resolve();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
        Object object = this.lock;
        synchronized (object) {
            if (this.executor != null) {
                this.executor = (Executor)SharedResourceHolder.release((SharedResourceHolder.Resource)GrpcUtil.SHARED_CHANNEL_EXECUTOR, (Object)this.executor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolve() {
        if (this.resolving || this.shutdown) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            this.executor.execute(this::doResolve);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doResolve() {
        NameResolver.Listener savedListener;
        Object object = this.lock;
        synchronized (object) {
            if (this.shutdown) {
                return;
            }
            this.resolving = true;
            savedListener = this.listener;
        }
        try {
            if (this.addresses.isEmpty()) {
                throw EtcdExceptionFactory.newEtcdException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)("Unable to resolve endpoint " + this.targetUri));
            }
            List servers = this.addresses.stream().map(address -> address.toAddressGroup(this.authority)).collect(Collectors.toList());
            savedListener.onAddresses(servers, Attributes.EMPTY);
        }
        catch (Exception e) {
            LOGGER.warn("Error wile getting list of servers", (Throwable)e);
            savedListener.onError(Status.NOT_FOUND);
        }
        finally {
            this.resolving = false;
        }
    }

    private static final class HostAndPort {
        final String host;
        final int port;

        public HostAndPort(String address) {
            Iterable split = Splitter.on((char)':').split((CharSequence)address);
            this.host = (String)Iterables.get((Iterable)split, (int)0);
            this.port = Integer.parseInt((String)Iterables.get((Iterable)split, (int)1, (Object)IPNameResolver.ETCD_CLIENT_PORT));
        }

        public String authority() {
            return String.format("%s:%d", this.host, this.port);
        }

        public EquivalentAddressGroup toAddressGroup(String authority) {
            return new EquivalentAddressGroup((SocketAddress)new InetSocketAddress(this.host, this.port), Strings.isNullOrEmpty((String)authority) ? Attributes.newBuilder().set(EquivalentAddressGroup.ATTR_AUTHORITY_OVERRIDE, (Object)this.authority()).build() : Attributes.EMPTY);
        }
    }
}

