/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational;

import io.debezium.doc.FixFor;
import io.debezium.relational.TableId;
import org.fest.assertions.Assertions;
import org.junit.Test;

public class TableIdTest {
    @Test
    @FixFor(value={"DBZ-3057"})
    public void shouldDoubleQuoteTableId() {
        TableId id = new TableId("catalog", "schema", "table");
        TableId doubleQuoted = id.toDoubleQuoted();
        Assertions.assertThat((String)doubleQuoted.catalog()).isEqualTo((Object)"\"catalog\"");
        Assertions.assertThat((String)doubleQuoted.schema()).isEqualTo((Object)"\"schema\"");
        Assertions.assertThat((String)doubleQuoted.table()).isEqualTo((Object)"\"table\"");
        Assertions.assertThat((String)doubleQuoted.toString()).isEqualTo((Object)"\"catalog\".\"schema\".\"table\"");
        Assertions.assertThat((String)doubleQuoted.toDoubleQuotedString()).isEqualTo((Object)"\"catalog\".\"schema\".\"table\"");
        id = new TableId("\"catalog\"", "\"schema\"", "\"table\"");
        doubleQuoted = id.toDoubleQuoted();
        Assertions.assertThat((Object)doubleQuoted).isEqualTo((Object)id);
    }

    @Test
    @FixFor(value={"DBZ-3057"})
    public void shouldQuoteTableIdWithGivenCharacter() {
        TableId id = new TableId("catalog", "schema", "table");
        TableId quoted = id.toQuoted('\'');
        Assertions.assertThat((String)quoted.catalog()).isEqualTo((Object)"'catalog'");
        Assertions.assertThat((String)quoted.schema()).isEqualTo((Object)"'schema'");
        Assertions.assertThat((String)quoted.table()).isEqualTo((Object)"'table'");
        Assertions.assertThat((String)quoted.toString()).isEqualTo((Object)"'catalog'.'schema'.'table'");
        Assertions.assertThat((String)quoted.toDoubleQuotedString()).isEqualTo((Object)"\"'catalog'\".\"'schema'\".\"'table'\"");
        id = new TableId("'catalog'", "'schema'", "'table'");
        quoted = id.toQuoted('\'');
        Assertions.assertThat((Object)quoted).isEqualTo((Object)id);
    }
}

