/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer;

import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.OracleOffsetContext;
import io.debezium.connector.oracle.Scn;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.txmetadata.TransactionContext;
import java.util.Collections;
import java.util.Map;

public class LogMinerOracleOffsetContextLoader
implements OffsetContext.Loader<OracleOffsetContext> {
    private final OracleConnectorConfig connectorConfig;

    public LogMinerOracleOffsetContextLoader(OracleConnectorConfig connectorConfig) {
        this.connectorConfig = connectorConfig;
    }

    public Map<String, ?> getPartition() {
        return Collections.singletonMap("server", this.connectorConfig.getLogicalName());
    }

    public OracleOffsetContext load(Map<String, ?> offset) {
        boolean snapshot = Boolean.TRUE.equals(offset.get("snapshot"));
        boolean snapshotCompleted = Boolean.TRUE.equals(offset.get("snapshot_completed"));
        Scn scn = OracleOffsetContext.getScnFromOffsetMapByKey(offset, "scn");
        Scn commitScn = OracleOffsetContext.getScnFromOffsetMapByKey(offset, "commit_scn");
        return new OracleOffsetContext(this.connectorConfig, scn, commitScn, null, snapshot, snapshotCompleted, TransactionContext.load(offset));
    }
}

