/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.connector.base.ChangeEventQueue;
import io.debezium.connector.mysql.MySqlConnection;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.MySqlDatabaseSchema;
import io.debezium.connector.mysql.MySqlOffsetContext;
import io.debezium.connector.mysql.MySqlPartition;
import io.debezium.connector.mysql.MySqlReadOnlyIncrementalSnapshotChangeEventSource;
import io.debezium.connector.mysql.MySqlSnapshotChangeEventSource;
import io.debezium.connector.mysql.MySqlSnapshotChangeEventSourceMetrics;
import io.debezium.connector.mysql.MySqlStreamingChangeEventSource;
import io.debezium.connector.mysql.MySqlStreamingChangeEventSourceMetrics;
import io.debezium.connector.mysql.MySqlTaskContext;
import io.debezium.function.BlockingConsumer;
import io.debezium.jdbc.MainConnectionProvidingConnectionFactory;
import io.debezium.pipeline.DataChangeEvent;
import io.debezium.pipeline.ErrorHandler;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.source.snapshot.incremental.IncrementalSnapshotChangeEventSource;
import io.debezium.pipeline.source.snapshot.incremental.SignalBasedIncrementalSnapshotChangeEventSource;
import io.debezium.pipeline.source.spi.ChangeEventSourceFactory;
import io.debezium.pipeline.source.spi.DataChangeEventListener;
import io.debezium.pipeline.source.spi.SnapshotChangeEventSource;
import io.debezium.pipeline.source.spi.SnapshotProgressListener;
import io.debezium.pipeline.source.spi.StreamingChangeEventSource;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.relational.TableId;
import io.debezium.schema.DatabaseSchema;
import io.debezium.spi.schema.DataCollectionId;
import io.debezium.util.Clock;
import io.debezium.util.Strings;
import java.util.Optional;
import java.util.function.Function;
import org.apache.kafka.connect.source.SourceRecord;

public class MySqlChangeEventSourceFactory
implements ChangeEventSourceFactory<MySqlPartition, MySqlOffsetContext> {
    private final MySqlConnectorConfig configuration;
    private final MainConnectionProvidingConnectionFactory<MySqlConnection> connectionFactory;
    private final ErrorHandler errorHandler;
    private final EventDispatcher<MySqlPartition, TableId> dispatcher;
    private final Clock clock;
    private final MySqlTaskContext taskContext;
    private final MySqlStreamingChangeEventSourceMetrics streamingMetrics;
    private final MySqlDatabaseSchema schema;
    private final ChangeEventQueue<DataChangeEvent> queue;

    public MySqlChangeEventSourceFactory(MySqlConnectorConfig configuration, MainConnectionProvidingConnectionFactory<MySqlConnection> connectionFactory, ErrorHandler errorHandler, EventDispatcher<MySqlPartition, TableId> dispatcher, Clock clock, MySqlDatabaseSchema schema, MySqlTaskContext taskContext, MySqlStreamingChangeEventSourceMetrics streamingMetrics, ChangeEventQueue<DataChangeEvent> queue) {
        this.configuration = configuration;
        this.connectionFactory = connectionFactory;
        this.errorHandler = errorHandler;
        this.dispatcher = dispatcher;
        this.clock = clock;
        this.taskContext = taskContext;
        this.streamingMetrics = streamingMetrics;
        this.queue = queue;
        this.schema = schema;
    }

    public SnapshotChangeEventSource<MySqlPartition, MySqlOffsetContext> getSnapshotChangeEventSource(SnapshotProgressListener<MySqlPartition> snapshotProgressListener) {
        return new MySqlSnapshotChangeEventSource(this.configuration, this.connectionFactory, this.taskContext.getSchema(), this.dispatcher, this.clock, (MySqlSnapshotChangeEventSourceMetrics)snapshotProgressListener, (BlockingConsumer<Function<SourceRecord, SourceRecord>>)((BlockingConsumer)this::modifyAndFlushLastRecord));
    }

    private void modifyAndFlushLastRecord(Function<SourceRecord, SourceRecord> modify) throws InterruptedException {
        this.queue.flushBuffer(dataChange -> new DataChangeEvent((SourceRecord)modify.apply(dataChange.getRecord())));
        this.queue.disableBuffering();
    }

    public StreamingChangeEventSource<MySqlPartition, MySqlOffsetContext> getStreamingChangeEventSource() {
        this.queue.disableBuffering();
        return new MySqlStreamingChangeEventSource(this.configuration, (MySqlConnection)this.connectionFactory.mainConnection(), this.dispatcher, this.errorHandler, this.clock, this.taskContext, this.streamingMetrics);
    }

    public Optional<IncrementalSnapshotChangeEventSource<MySqlPartition, ? extends DataCollectionId>> getIncrementalSnapshotChangeEventSource(MySqlOffsetContext offsetContext, SnapshotProgressListener<MySqlPartition> snapshotProgressListener, DataChangeEventListener<MySqlPartition> dataChangeEventListener) {
        if (this.configuration.isReadOnlyConnection()) {
            if (((MySqlConnection)this.connectionFactory.mainConnection()).isGtidModeEnabled()) {
                return Optional.of(new MySqlReadOnlyIncrementalSnapshotChangeEventSource<TableId>((RelationalDatabaseConnectorConfig)this.configuration, this.connectionFactory.mainConnection(), this.dispatcher, (DatabaseSchema<?>)this.schema, this.clock, snapshotProgressListener, dataChangeEventListener));
            }
            throw new UnsupportedOperationException("Read only connection requires GTID_MODE to be ON");
        }
        if (Strings.isNullOrEmpty((String)this.configuration.getSignalingDataCollectionId())) {
            return Optional.empty();
        }
        return Optional.of(new SignalBasedIncrementalSnapshotChangeEventSource((RelationalDatabaseConnectorConfig)this.configuration, this.connectionFactory.mainConnection(), this.dispatcher, (DatabaseSchema)this.schema, this.clock, snapshotProgressListener, dataChangeEventListener));
    }
}

