/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.annotation.NotThreadSafe;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.connector.mysql.Filters;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.MySqlSystemVariables;
import io.debezium.connector.mysql.MySqlValueConverters;
import io.debezium.connector.mysql.SourceInfo;
import io.debezium.document.Document;
import io.debezium.jdbc.JdbcValueConverters;
import io.debezium.jdbc.TemporalPrecisionMode;
import io.debezium.relational.RelationalDatabaseSchema;
import io.debezium.relational.SystemVariables;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.relational.TableSchemaBuilder;
import io.debezium.relational.Tables;
import io.debezium.relational.ValueConverterProvider;
import io.debezium.relational.ddl.DdlChanges;
import io.debezium.relational.ddl.DdlParser;
import io.debezium.relational.history.DatabaseHistory;
import io.debezium.relational.history.HistoryRecordComparator;
import io.debezium.schema.TopicSelector;
import io.debezium.text.MultipleParsingExceptions;
import io.debezium.text.ParsingException;
import io.debezium.util.Collect;
import io.debezium.util.SchemaNameAdjuster;
import java.lang.invoke.LambdaMetafactory;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.kafka.connect.errors.ConnectException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class MySqlSchema
extends RelationalDatabaseSchema {
    private static final Logger logger = LoggerFactory.getLogger(MySqlSchema.class);
    private final Set<String> ignoredQueryStatements = Collect.unmodifiableSet((Object[])new String[]{"BEGIN", "END", "FLUSH PRIVILEGES"});
    private final DdlParser ddlParser;
    private final Filters filters;
    private final DatabaseHistory dbHistory;
    private final DdlChanges ddlChanges;
    private final HistoryRecordComparator historyComparator;
    private final boolean skipUnparseableDDL;
    private final boolean storeOnlyMonitoredTablesDdl;

    public MySqlSchema(MySqlConnectorConfig configuration, final Predicate<String> gtidFilter, boolean tableIdCaseInsensitive, TopicSelector<TableId> topicSelector, Filters tableFilters) {
        super((CommonConnectorConfig)configuration, topicSelector, Tables.TableFilter.fromPredicate(tableFilters.tableFilter()), tableFilters.columnFilter(), new TableSchemaBuilder((ValueConverterProvider)MySqlSchema.getValueConverters(configuration), SchemaNameAdjuster.create((Logger)logger), SourceInfo.SCHEMA), tableIdCaseInsensitive);
        Configuration config = configuration.getConfig();
        this.filters = tableFilters;
        String connectorName = config.getString("name", configuration.getLogicalName());
        Configuration dbHistoryConfig = ((Configuration.Builder)config.subset("database.history.", false).edit().withDefault(DatabaseHistory.NAME, connectorName + "-dbhistory")).build();
        this.skipUnparseableDDL = dbHistoryConfig.getBoolean(DatabaseHistory.SKIP_UNPARSEABLE_DDL_STATEMENTS);
        this.storeOnlyMonitoredTablesDdl = dbHistoryConfig.getBoolean(DatabaseHistory.STORE_ONLY_MONITORED_TABLES_DDL);
        this.ddlParser = configuration.getDdlParsingMode().getNewParserInstance(MySqlSchema.getValueConverters(configuration), this.getTableFilter());
        this.ddlChanges = this.ddlParser.getDdlChanges();
        this.dbHistory = (DatabaseHistory)config.getInstance(MySqlConnectorConfig.DATABASE_HISTORY, DatabaseHistory.class);
        if (this.dbHistory == null) {
            throw new ConnectException("Unable to instantiate the database history class " + config.getString(MySqlConnectorConfig.DATABASE_HISTORY));
        }
        this.historyComparator = new HistoryRecordComparator(){

            protected boolean isPositionAtOrBefore(Document recorded, Document desired) {
                return SourceInfo.isPositionAtOrBefore(recorded, desired, gtidFilter);
            }
        };
        this.dbHistory.configure(dbHistoryConfig, this.historyComparator);
    }

    private static MySqlValueConverters getValueConverters(MySqlConnectorConfig configuration) {
        String timePrecisionModeStr = configuration.getConfig().getString(MySqlConnectorConfig.TIME_PRECISION_MODE);
        TemporalPrecisionMode timePrecisionMode = TemporalPrecisionMode.parse((String)timePrecisionModeStr);
        JdbcValueConverters.DecimalMode decimalMode = configuration.getDecimalMode();
        String bigIntUnsignedHandlingModeStr = configuration.getConfig().getString(MySqlConnectorConfig.BIGINT_UNSIGNED_HANDLING_MODE);
        MySqlConnectorConfig.BigIntUnsignedHandlingMode bigIntUnsignedHandlingMode = MySqlConnectorConfig.BigIntUnsignedHandlingMode.parse(bigIntUnsignedHandlingModeStr);
        JdbcValueConverters.BigIntUnsignedMode bigIntUnsignedMode = bigIntUnsignedHandlingMode.asBigIntUnsignedMode();
        return new MySqlValueConverters(decimalMode, timePrecisionMode, bigIntUnsignedMode);
    }

    protected HistoryRecordComparator historyComparator() {
        return this.historyComparator;
    }

    public synchronized void start() {
        this.dbHistory.start();
    }

    public synchronized void shutdown() {
        this.dbHistory.stop();
    }

    public Filters filters() {
        return this.filters;
    }

    public String[] monitoredTablesAsStringArray() {
        Set tables = this.tableIds();
        String[] ret = new String[tables.size()];
        int i = 0;
        for (TableId table : tables) {
            ret[i++] = table.toString();
        }
        return ret;
    }

    public boolean isTableMonitored(TableId id) {
        return this.filters.tableFilter().test(id);
    }

    public String historyLocation() {
        return this.dbHistory.toString();
    }

    public void setSystemVariables(Map<String, String> variables) {
        variables.forEach((varName, value) -> this.ddlParser.systemVariables().setVariable((SystemVariables.Scope)MySqlSystemVariables.MySqlScope.SESSION, varName, value));
    }

    public SystemVariables systemVariables() {
        return this.ddlParser.systemVariables();
    }

    protected void appendDropTableStatement(StringBuilder sb, TableId tableId) {
        sb.append("DROP TABLE ").append(tableId).append(" IF EXISTS;").append(System.lineSeparator());
    }

    protected void appendCreateTableStatement(StringBuilder sb, Table table) {
        sb.append("CREATE TABLE ").append(table.id()).append(';').append(System.lineSeparator());
    }

    public void loadHistory(SourceInfo startingPoint) {
        this.tables().clear();
        this.dbHistory.recover(startingPoint.partition(), startingPoint.offset(), this.tables(), this.ddlParser);
        this.refreshSchemas();
    }

    public boolean historyExists() {
        return this.dbHistory.exists();
    }

    public void intializeHistoryStorage() {
        this.dbHistory.initializeStorage();
    }

    protected void refreshSchemas() {
        this.clearSchemas();
        this.tableIds().forEach(id -> {
            Table table = this.tableFor((TableId)id);
            this.buildAndRegisterSchema(table);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public boolean applyDdl(SourceInfo source, String databaseName, String ddlStatements, DdlChanges.DatabaseStatementStringConsumer statementConsumer) {
        block20: {
            if (this.ignoredQueryStatements.contains(ddlStatements)) {
                return false;
            }
            try {
                this.ddlChanges.reset();
                this.ddlParser.setCurrentSchema(databaseName);
                this.ddlParser.parse(ddlStatements, this.tables());
            }
            catch (MultipleParsingExceptions | ParsingException e) {
                if (this.skipUnparseableDDL) {
                    MySqlSchema.logger.warn("Ignoring unparseable DDL statement '{}': {}", (Object)ddlStatements, (Object)e);
                    break block20;
                }
                throw e;
            }
            finally {
                block21: {
                    changes = this.tables().drainChanges();
                    if (this.storeOnlyMonitoredTablesDdl && changes.isEmpty()) break block21;
                    if (statementConsumer != null) {
                        if (!this.ddlChanges.isEmpty() && this.ddlChanges.applyToMoreDatabasesThan(databaseName)) {
                            this.ddlChanges.groupStatementStringsByDatabase((DdlChanges.DatabaseStatementStringConsumer)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/String;Ljava/lang/String;)V, lambda$applyDdl$2(io.debezium.relational.ddl.DdlChanges$DatabaseStatementStringConsumer java.lang.String java.lang.String java.lang.String ), (Ljava/lang/String;Ljava/lang/String;)V)((MySqlSchema)this, (DdlChanges.DatabaseStatementStringConsumer)statementConsumer, (String)ddlStatements));
                        } else if (this.filters.databaseFilter().test(databaseName) || databaseName == null || "".equals(databaseName)) {
                            if (databaseName == null) {
                                databaseName = "";
                            }
                            statementConsumer.consume(databaseName, ddlStatements);
                        }
                    }
                    try {
                        if (!this.storeOnlyMonitoredTablesDdl) ** GOTO lbl-1000
                        if (changes.stream().anyMatch((Predicate<TableId>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, test(T ), (Lio/debezium/relational/TableId;)Z)(this.filters().tableFilter()))) lbl-1000:
                        // 2 sources

                        {
                            this.dbHistory.record(source.partition(), source.offset(), databaseName, ddlStatements);
                        } else {
                            MySqlSchema.logger.debug("Changes for DDL '{}' were filtered and not recorded in database history", (Object)ddlStatements);
                        }
                    }
                    catch (Throwable e) {
                        throw new ConnectException("Error recording the DDL statement(s) in the database history " + this.dbHistory + ": " + ddlStatements, e);
                    }
                }
            }
        }
        changes.forEach((Consumer<TableId>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$applyDdl$3(io.debezium.relational.TableId ), (Lio/debezium/relational/TableId;)V)((MySqlSchema)this));
        return true;
    }

    private /* synthetic */ void lambda$applyDdl$3(TableId tableId) {
        Table table = this.tableFor(tableId);
        if (table == null) {
            this.removeSchema(tableId);
        } else {
            this.buildAndRegisterSchema(table);
        }
    }

    private /* synthetic */ void lambda$applyDdl$2(DdlChanges.DatabaseStatementStringConsumer statementConsumer, String ddlStatements, String dbName, String ddl) {
        if (this.filters.databaseFilter().test(dbName) || dbName == null || "".equals(dbName)) {
            if (dbName == null) {
                dbName = "";
            }
            statementConsumer.consume(dbName, ddlStatements);
        }
    }
}

