/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.checkstyle;

import com.puppycrawl.tools.checkstyle.api.FileText;
import com.puppycrawl.tools.checkstyle.checks.header.HeaderCheck;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;

public class Header
extends HeaderCheck {
    private Set<String> excludedFileSet;
    private String excludedFilesRegex;
    private Pattern excludedFilesPattern;
    private final String workingDirPath = new File(".").getAbsoluteFile().getParentFile().getAbsolutePath();
    private final int workingDirPathLength = this.workingDirPath.length();

    public void setExcludedFilesRegex(String excludedFilePattern) {
        this.excludedFilesRegex = excludedFilePattern;
        this.excludedFilesPattern = Pattern.compile(this.excludedFilesRegex);
    }

    public void setExcludedClasses(String excludedClasses) {
        this.excludedFileSet = new HashSet<String>();
        if (excludedClasses != null) {
            for (String classname : excludedClasses.split(",")) {
                if (classname == null || classname.trim().length() == 0) continue;
                String path = classname.trim().replace('.', '/') + ".java";
                this.excludedFileSet.add(path.trim());
            }
        }
    }

    public void setHeaderFile(String aFileName) {
        InputStream stream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("debezium.header");
        if (stream == null) {
            throw new RuntimeException("unable to load header file (using classloader) " + aFileName);
        }
        try {
            String l;
            LineNumberReader lnr = new LineNumberReader(new InputStreamReader(stream));
            StringBuilder sb = new StringBuilder();
            while ((l = lnr.readLine()) != null) {
                sb.append(l).append("\\n");
            }
            super.setHeader(sb.toString());
        }
        catch (IOException e) {
            throw new RuntimeException("problem reading header file (using classloader) " + aFileName, e);
        }
    }

    protected boolean isExcluded(File file) {
        String filename = file.getAbsolutePath().replace(File.separator, "/");
        if (filename.startsWith(this.workingDirPath)) {
            filename = filename.substring(this.workingDirPathLength);
        }
        filename = filename.replaceAll(".*/src/(main|test)/(java|resources)/", "");
        for (String excludedFileName : this.excludedFileSet) {
            if (!filename.endsWith(excludedFileName)) continue;
            return true;
        }
        return this.excludedFilesPattern != null && this.excludedFilesPattern.matcher(filename).matches();
    }

    protected void processFiltered(File aFile, FileText fileText) {
        if (this.isExcluded(aFile)) {
            return;
        }
        super.processFiltered(aFile, fileText);
    }
}

