/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;

public class Config {
    private static Config mainInstance = null;
    private static final String MAIN_CONFIG = "main.properties";
    private static final Map<String, Properties> cache = new ConcurrentHashMap<String, Properties>();
    private final String configName;

    public static synchronized Config main() {
        if (mainInstance == null) {
            mainInstance = new Config(MAIN_CONFIG);
        }
        return mainInstance;
    }

    private Config(String configName) {
        this.configName = configName;
    }

    public <T> T getValue(String key, Class<T> valueType) {
        return this.getOptionalValue(key, valueType).orElseThrow(() -> new IllegalArgumentException(String.format("There is no '%s' key in '%s' config", key, this.configName)));
    }

    public <T> Optional<T> getOptionalValue(String key, Class<T> valueType) {
        Properties cachedProps = cache.computeIfAbsent(this.configName, k -> {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (InputStream configFileStream = this.getClass().getClassLoader().getResourceAsStream(this.configName);){
                    Properties p = new Properties();
                    p.load(configFileStream);
                    return p;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(String.format("Configuration file '%s' cannot be loaded", this.configName), e);
            }
        });
        return cachedProps.containsKey(key) ? Optional.of(valueType.cast(cachedProps.get(key))) : Optional.empty();
    }
}

