/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.serde.jsonschema;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.ValidationMessage;
import io.apicurio.registry.serde.ParsedSchema;
import java.io.IOException;
import java.util.Set;

public class JsonSchemaValidationUtil {
    protected static void validateDataWithSchema(ParsedSchema<JsonSchema> schema, byte[] data, ObjectMapper mapper) throws IOException {
        Set validationMessages = ((JsonSchema)schema.getParsedSchema()).validate(mapper.readTree(data));
        if (validationMessages != null && !validationMessages.isEmpty()) {
            StringBuilder message = new StringBuilder();
            for (ValidationMessage validationMessage : validationMessages) {
                message.append(validationMessage.getMessage()).append(" ");
            }
            throw new IOException(String.format("Error validating data against json schema with message: %s", message));
        }
    }
}

