/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.serde.strategy;

public class ArtifactReference {
    private String groupId;
    private String artifactId;
    private String version;
    private Long globalId;
    private Long contentId;

    private ArtifactReference() {
    }

    public boolean hasValue() {
        return this.groupId != null || this.artifactId != null || this.version != null || this.globalId != null || this.contentId != null;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public Long getGlobalId() {
        return this.globalId;
    }

    public Long getContentId() {
        return this.contentId;
    }

    private void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    private void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    private void setVersion(String version) {
        this.version = version;
    }

    private void setGlobalId(Long globalId) {
        this.globalId = globalId;
    }

    private void setContentId(Long contentId) {
        this.contentId = contentId;
    }

    public int hashCode() {
        return this.globalId == null ? 0 : this.globalId.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArtifactReference other = (ArtifactReference)obj;
        boolean match1 = false;
        if (this.globalId != null && other.globalId != null) {
            if (!this.globalId.equals(other.globalId)) {
                return false;
            }
            match1 = true;
        }
        boolean match2 = false;
        if (this.contentId != null && other.contentId != null) {
            if (!this.contentId.equals(other.contentId)) {
                return false;
            }
            match2 = true;
        }
        boolean match3 = false;
        if (this.groupId != null && other.groupId != null) {
            if (!this.groupId.equals(other.groupId)) {
                return false;
            }
            match3 = true;
        }
        boolean match4 = false;
        if (this.artifactId != null && other.artifactId != null) {
            if (!this.artifactId.equals(other.artifactId)) {
                return false;
            }
            match4 = true;
        }
        boolean match5 = false;
        if (this.version != null && other.version != null) {
            if (!this.version.equals(other.version)) {
                return false;
            }
            match5 = true;
        }
        return match1 || match2 || match3 && match4 && match5;
    }

    public String toString() {
        return "ArtifactReference [groupId=" + this.groupId + ", artifactId=" + this.artifactId + ", version=" + this.version + ", globalId=" + this.globalId + ", contentId=" + this.contentId + "]";
    }

    public static ArtifactReference fromGlobalId(Long globalId) {
        return ArtifactReference.builder().globalId(globalId).build();
    }

    public static ArtifactReferenceBuilder builder() {
        return new ArtifactReferenceBuilder();
    }

    public static class ArtifactReferenceBuilder {
        private ArtifactReference reference = new ArtifactReference();

        ArtifactReferenceBuilder() {
        }

        public ArtifactReferenceBuilder groupId(String groupId) {
            this.reference.setGroupId(groupId);
            return this;
        }

        public ArtifactReferenceBuilder artifactId(String artifactId) {
            this.reference.setArtifactId(artifactId);
            return this;
        }

        public ArtifactReferenceBuilder version(String version) {
            this.reference.setVersion(version);
            return this;
        }

        public ArtifactReferenceBuilder globalId(Long globalId) {
            this.reference.setGlobalId(globalId);
            return this;
        }

        public ArtifactReferenceBuilder contentId(Long contentId) {
            this.reference.setContentId(contentId);
            return this;
        }

        public ArtifactReference build() {
            return this.reference;
        }
    }
}

