/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.serde;

import io.apicurio.registry.rest.v2.beans.ArtifactMetaData;
import io.apicurio.registry.rest.v2.beans.IfExists;
import io.apicurio.registry.rest.v2.beans.VersionMetaData;
import io.apicurio.registry.serde.AbstractSchemaResolver;
import io.apicurio.registry.serde.ParsedSchema;
import io.apicurio.registry.serde.SchemaLookupResult;
import io.apicurio.registry.serde.SchemaParser;
import io.apicurio.registry.serde.config.DefaultSchemaResolverConfig;
import io.apicurio.registry.serde.strategy.ArtifactReference;
import io.apicurio.registry.utils.IoUtil;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.common.header.Headers;

public class DefaultSchemaResolver<S, T>
extends AbstractSchemaResolver<S, T> {
    private boolean autoCreateArtifact;
    private IfExists autoCreateBehavior;
    private boolean findLatest;

    @Override
    public void reset() {
        super.reset();
    }

    @Override
    public void configure(Map<String, ?> configs, boolean isKey, SchemaParser<S> schemaParser) {
        super.configure(configs, isKey, schemaParser);
        DefaultSchemaResolverConfig config = new DefaultSchemaResolverConfig(configs);
        this.autoCreateArtifact = config.autoRegisterArtifact();
        this.autoCreateBehavior = IfExists.fromValue((String)config.autoRegisterArtifactIfExists());
        this.findLatest = config.findLatest();
    }

    @Override
    public SchemaLookupResult<S> resolveSchema(String topic, Headers headers, T data, ParsedSchema<S> parsedSchema) {
        Objects.requireNonNull(topic);
        Objects.requireNonNull(data);
        ArtifactReference artifactReference = this.resolveArtifactReference(topic, headers, data, parsedSchema);
        if (this.schemaCache.containsByArtifactReference(artifactReference)) {
            return this.resolveSchemaByArtifactReferenceCached(artifactReference);
        }
        if (this.autoCreateArtifact && parsedSchema != null && parsedSchema.getRawSchema() != null) {
            return this.handleAutoCreateArtifact(parsedSchema, artifactReference);
        }
        if (this.findLatest || artifactReference.getVersion() != null) {
            return this.resolveSchemaByCoordinates(artifactReference.getGroupId(), artifactReference.getArtifactId(), artifactReference.getVersion());
        }
        if (parsedSchema != null && parsedSchema.getRawSchema() != null) {
            return this.handleResolveSchemaByContent(parsedSchema, artifactReference);
        }
        return this.resolveSchemaByCoordinates(artifactReference.getGroupId(), artifactReference.getArtifactId(), artifactReference.getVersion());
    }

    @Override
    public SchemaLookupResult<S> resolveSchemaByArtifactReference(ArtifactReference reference) {
        if (reference.getContentId() != null) {
            return this.resolveSchemaByContentId(reference.getContentId());
        }
        if (reference.getGlobalId() == null) {
            return this.resolveSchemaByCoordinates(reference.getGroupId(), reference.getArtifactId(), reference.getVersion());
        }
        return this.resolveSchemaByGlobalId(reference.getGlobalId());
    }

    private SchemaLookupResult<S> resolveSchemaByCoordinates(String groupId, String artifactId, String version) {
        if (artifactId == null) {
            throw new IllegalStateException("artifactId cannot be null");
        }
        ArtifactReference reference = ArtifactReference.builder().groupId(groupId).artifactId(artifactId).version(version).build();
        return this.resolveSchemaByArtifactReferenceCached(reference);
    }

    protected SchemaLookupResult<S> resolveSchemaByContentId(long contentId) {
        return this.schemaCache.getByContentId(contentId, contentIdKey -> {
            InputStream rawSchema = this.client.getContentById(contentIdKey.longValue());
            byte[] schema = IoUtil.toBytes((InputStream)rawSchema);
            Object parsed = this.schemaParser.parseSchema(schema);
            SchemaLookupResult.SchemaLookupResultBuilder result = SchemaLookupResult.builder();
            return result.contentId((long)contentIdKey).rawSchema(schema).schema(parsed).build();
        });
    }

    private SchemaLookupResult<S> handleResolveSchemaByContent(ParsedSchema<S> parsedSchema, ArtifactReference artifactReference) {
        String rawSchemaString = IoUtil.toString((byte[])parsedSchema.getRawSchema());
        return this.schemaCache.getByContent(rawSchemaString, contentKey -> {
            VersionMetaData artifactMetadata = this.client.getArtifactVersionMetaDataByContent(artifactReference.getGroupId(), artifactReference.getArtifactId(), Boolean.valueOf(true), IoUtil.toStream((String)contentKey));
            SchemaLookupResult.SchemaLookupResultBuilder result = SchemaLookupResult.builder();
            this.loadFromArtifactMetaData(artifactMetadata, result);
            result.rawSchema(parsedSchema.getRawSchema());
            result.schema(parsedSchema.getParsedSchema());
            return result.build();
        });
    }

    private SchemaLookupResult<S> handleAutoCreateArtifact(ParsedSchema<S> parsedSchema, ArtifactReference artifactReference) {
        String rawSchemaString = IoUtil.toString((byte[])parsedSchema.getRawSchema());
        return this.schemaCache.getByContent(rawSchemaString, contentKey -> {
            ArtifactMetaData artifactMetadata = this.client.createArtifact(artifactReference.getGroupId(), artifactReference.getArtifactId(), artifactReference.getVersion(), this.schemaParser.artifactType(), this.autoCreateBehavior, Boolean.valueOf(false), IoUtil.toStream((byte[])parsedSchema.getRawSchema()));
            SchemaLookupResult.SchemaLookupResultBuilder result = SchemaLookupResult.builder();
            this.loadFromArtifactMetaData(artifactMetadata, result);
            result.rawSchema(parsedSchema.getRawSchema());
            result.schema(parsedSchema.getParsedSchema());
            return result.build();
        });
    }

    private SchemaLookupResult<S> resolveSchemaByArtifactReferenceCached(ArtifactReference artifactReference) {
        return this.schemaCache.getByArtifactReference(artifactReference, artifactReferenceKey -> {
            Long gid;
            ArtifactMetaData metadata;
            SchemaLookupResult.SchemaLookupResultBuilder result = SchemaLookupResult.builder();
            if (artifactReferenceKey.getVersion() == null) {
                metadata = this.client.getArtifactMetaData(artifactReferenceKey.getGroupId(), artifactReferenceKey.getArtifactId());
                this.loadFromArtifactMetaData(metadata, result);
                gid = metadata.getGlobalId();
            } else {
                metadata = this.client.getArtifactVersionMetaData(artifactReferenceKey.getGroupId(), artifactReferenceKey.getArtifactId(), artifactReferenceKey.getVersion());
                this.loadFromArtifactMetaData((VersionMetaData)metadata, result);
                gid = metadata.getGlobalId();
            }
            InputStream rawSchema = this.client.getContentByGlobalId(gid.longValue());
            byte[] schema = IoUtil.toBytes((InputStream)rawSchema);
            Object parsed = this.schemaParser.parseSchema(schema);
            result.rawSchema(schema).schema(parsed);
            return result.build();
        });
    }
}

