/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.command.model;

import com.google.common.collect.ImmutableList;
import io.airlift.command.model.CommandGroupMetadata;
import io.airlift.command.model.CommandMetadata;
import io.airlift.command.model.OptionMetadata;
import java.util.List;

public class GlobalMetadata {
    private final String name;
    private final String description;
    private final List<OptionMetadata> options;
    private final CommandMetadata defaultCommand;
    private final List<CommandMetadata> defaultGroupCommands;
    private final List<CommandGroupMetadata> commandGroups;

    public GlobalMetadata(String name, String description, Iterable<OptionMetadata> options, CommandMetadata defaultCommand, Iterable<CommandMetadata> defaultGroupCommands, Iterable<CommandGroupMetadata> commandGroups) {
        this.name = name;
        this.description = description;
        this.options = ImmutableList.copyOf(options);
        this.defaultCommand = defaultCommand;
        this.defaultGroupCommands = ImmutableList.copyOf(defaultGroupCommands);
        this.commandGroups = ImmutableList.copyOf(commandGroups);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public List<OptionMetadata> getOptions() {
        return this.options;
    }

    public CommandMetadata getDefaultCommand() {
        return this.defaultCommand;
    }

    public List<CommandMetadata> getDefaultGroupCommands() {
        return this.defaultGroupCommands;
    }

    public List<CommandGroupMetadata> getCommandGroups() {
        return this.commandGroups;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("GlobalMetadata");
        sb.append("{name='").append(this.name).append('\'');
        sb.append(", description='").append(this.description).append('\'');
        sb.append(", options=").append(this.options);
        sb.append(", defaultCommand=").append(this.defaultCommand);
        sb.append(", defaultGroupCommands=").append(this.defaultGroupCommands);
        sb.append(", commandGroups=").append(this.commandGroups);
        sb.append('}');
        return sb.toString();
    }
}

