/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.sys.utils;

import com.alibaba.nacos.common.executor.ExecutorFactory;
import com.alibaba.nacos.common.executor.NameThreadFactory;
import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.common.notify.SlowEvent;
import com.alibaba.nacos.common.utils.InternetAddressUtil;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.sys.env.EnvUtil;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InetUtils {
    private static final Logger LOG = LoggerFactory.getLogger(InetUtils.class);
    private static final List<String> PREFERRED_NETWORKS = new ArrayList<String>();
    private static final List<String> IGNORED_INTERFACES = new ArrayList<String>();
    private static final ScheduledExecutorService INET_AUTO_REFRESH_EXECUTOR = ExecutorFactory.Managed.newSingleScheduledExecutorService((String)InetUtils.class.getCanonicalName(), (ThreadFactory)new NameThreadFactory("com.alibaba.inet.ip.auto-refresh"));
    private static volatile String selfIP;
    private static boolean useOnlySiteLocalInterface;
    private static boolean preferHostnameOverIP;

    private static void refreshIp() {
        String tmpSelfIp = InetUtils.getNacosIp();
        if (StringUtils.isBlank((CharSequence)tmpSelfIp)) {
            tmpSelfIp = InetUtils.getPreferHostnameOverIP();
        }
        if (StringUtils.isBlank((CharSequence)tmpSelfIp)) {
            tmpSelfIp = Objects.requireNonNull(InetUtils.findFirstNonLoopbackAddress()).getHostAddress();
        }
        if (InternetAddressUtil.PREFER_IPV6_ADDRESSES && !tmpSelfIp.startsWith("[") && !tmpSelfIp.endsWith("]") && StringUtils.contains((CharSequence)(tmpSelfIp = "[" + tmpSelfIp + "]"), (CharSequence)"%")) {
            tmpSelfIp = tmpSelfIp.substring(0, tmpSelfIp.indexOf("%")) + "]";
        }
        if (!Objects.equals(selfIP, tmpSelfIp) && Objects.nonNull(selfIP)) {
            IPChangeEvent event = new IPChangeEvent();
            event.setOldIP(selfIP);
            event.setNewIP(tmpSelfIp);
            NotifyCenter.publishEvent((Event)event);
        }
        selfIP = tmpSelfIp;
    }

    public static String getNacosIp() {
        String nacosIp = System.getProperty("nacos.server.ip");
        if (StringUtils.isBlank((CharSequence)nacosIp)) {
            nacosIp = EnvUtil.getProperty("nacos.inetutils.ip-address");
        }
        if (!(StringUtils.isBlank((CharSequence)nacosIp) || InternetAddressUtil.isIP((String)nacosIp) || InternetAddressUtil.isDomain((String)nacosIp))) {
            throw new RuntimeException("nacos address " + nacosIp + " is not ip");
        }
        return nacosIp;
    }

    private static String getPreferHostnameOverIP() {
        preferHostnameOverIP = Boolean.getBoolean("nacos.preferHostnameOverIp");
        if (!preferHostnameOverIP) {
            preferHostnameOverIP = Boolean.parseBoolean(EnvUtil.getProperty("nacos.inetutils.prefer-hostname-over-ip"));
        }
        if (!preferHostnameOverIP) {
            return null;
        }
        String preferHostnameOverIp = null;
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            preferHostnameOverIp = inetAddress.getHostName().equals(inetAddress.getCanonicalHostName()) ? inetAddress.getHostName() : inetAddress.getCanonicalHostName();
        }
        catch (UnknownHostException ignore) {
            LOG.warn("Unable to retrieve localhost");
        }
        return preferHostnameOverIp;
    }

    public static String getSelfIP() {
        return selfIP;
    }

    public static InetAddress findFirstNonLoopbackAddress() {
        InetAddress result = null;
        try {
            int lowest = Integer.MAX_VALUE;
            Enumeration<NetworkInterface> nics = NetworkInterface.getNetworkInterfaces();
            while (nics.hasMoreElements()) {
                NetworkInterface ifc = nics.nextElement();
                if (!ifc.isUp()) continue;
                LOG.debug("Testing interface: " + ifc.getDisplayName());
                if (ifc.getIndex() >= lowest && result != null) continue;
                lowest = ifc.getIndex();
                if (InetUtils.ignoreInterface(ifc.getDisplayName())) continue;
                Enumeration<InetAddress> addrs = ifc.getInetAddresses();
                while (addrs.hasMoreElements()) {
                    InetAddress address = addrs.nextElement();
                    boolean isLegalIpVersion = InternetAddressUtil.PREFER_IPV6_ADDRESSES ? address instanceof Inet6Address : address instanceof Inet4Address;
                    if (!isLegalIpVersion || address.isLoopbackAddress() || !InetUtils.isPreferredAddress(address)) continue;
                    LOG.debug("Found non-loopback interface: " + ifc.getDisplayName());
                    result = address;
                }
            }
        }
        catch (IOException ex) {
            LOG.error("Cannot get first non-loopback address", (Throwable)ex);
        }
        if (result != null) {
            return result;
        }
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            LOG.error("Unable to retrieve localhost", (Throwable)e);
            return null;
        }
    }

    private static boolean isPreferredAddress(InetAddress address) {
        if (useOnlySiteLocalInterface) {
            boolean siteLocalAddress = address.isSiteLocalAddress();
            if (!siteLocalAddress) {
                LOG.debug("Ignoring address: " + address.getHostAddress());
            }
            return siteLocalAddress;
        }
        if (PREFERRED_NETWORKS.isEmpty()) {
            return true;
        }
        for (String regex : PREFERRED_NETWORKS) {
            String hostAddress = address.getHostAddress();
            if (!hostAddress.matches(regex) && !hostAddress.startsWith(regex)) continue;
            return true;
        }
        return false;
    }

    private static boolean ignoreInterface(String interfaceName) {
        for (String regex : IGNORED_INTERFACES) {
            if (!interfaceName.matches(regex)) continue;
            LOG.debug("Ignoring interface: " + interfaceName);
            return true;
        }
        return false;
    }

    static {
        useOnlySiteLocalInterface = false;
        preferHostnameOverIP = false;
        NotifyCenter.registerToSharePublisher(IPChangeEvent.class);
        useOnlySiteLocalInterface = Boolean.parseBoolean(EnvUtil.getProperty("nacos.inetutils.use-only-site-local-interfaces"));
        List<String> networks = EnvUtil.getPropertyList("nacos.inetutils.preferred-networks");
        PREFERRED_NETWORKS.addAll(networks);
        List<String> interfaces = EnvUtil.getPropertyList("nacos.inetutils.ignored-interfaces");
        IGNORED_INTERFACES.addAll(interfaces);
        InetUtils.refreshIp();
        long delayMs = Long.getLong("nacos.core.inet.auto-refresh", 30000L);
        INET_AUTO_REFRESH_EXECUTOR.scheduleAtFixedRate(() -> {
            try {
                InetUtils.refreshIp();
            }
            catch (Exception e) {
                LOG.error("refresh ip error", (Throwable)e);
            }
        }, delayMs, delayMs, TimeUnit.MILLISECONDS);
    }

    public static class IPChangeEvent
    extends SlowEvent {
        private String oldIP;
        private String newIP;

        public String getOldIP() {
            return this.oldIP;
        }

        public void setOldIP(String oldIP) {
            this.oldIP = oldIP;
        }

        public String getNewIP() {
            return this.newIP;
        }

        public void setNewIP(String newIP) {
            this.newIP = newIP;
        }

        public String toString() {
            return "IPChangeEvent{oldIP='" + this.oldIP + '\'' + ", newIP='" + this.newIP + '\'' + '}';
        }
    }
}

