/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.sys.utils;

import com.alibaba.nacos.common.utils.ByteUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.zip.CheckedInputStream;
import java.util.zip.CheckedOutputStream;
import java.util.zip.Checksum;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.NullOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DiskUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(DiskUtils.class);
    private static final String NO_SPACE_CN = "\u8bbe\u5907\u4e0a\u6ca1\u6709\u7a7a\u95f4";
    private static final String NO_SPACE_EN = "No space left on device";
    private static final String DISK_QUOTA_CN = "\u8d85\u51fa\u78c1\u76d8\u9650\u989d";
    private static final String DISK_QUOTA_EN = "Disk quota exceeded";
    private static final Charset CHARSET = StandardCharsets.UTF_8;
    private static final CharsetDecoder DECODER = CHARSET.newDecoder();

    public static void touch(String path, String fileName) throws IOException {
        FileUtils.touch((File)Paths.get(path, fileName).toFile());
    }

    public static void touch(File file) throws IOException {
        FileUtils.touch((File)file);
    }

    public static File createTmpFile(String dir, String prefix, String suffix) throws IOException {
        return Files.createTempFile(Paths.get(dir, new String[0]), prefix, suffix, new FileAttribute[0]).toFile();
    }

    public static File createTmpFile(String prefix, String suffix) throws IOException {
        return Files.createTempFile(prefix, suffix, new FileAttribute[0]).toFile();
    }

    public static String readFile(String path, String fileName) {
        File file = DiskUtils.openFile(path, fileName);
        if (file.exists()) {
            return DiskUtils.readFile(file);
        }
        return null;
    }

    public static String readFile(InputStream is) {
        String string;
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        try {
            StringBuilder textBuilder = new StringBuilder();
            String lineTxt = null;
            while ((lineTxt = reader.readLine()) != null) {
                textBuilder.append(lineTxt);
            }
            string = textBuilder.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return null;
            }
        }
        reader.close();
        return string;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String readFile(File file) {
        try (FileInputStream fis = new FileInputStream(file);){
            String string;
            block15: {
                FileChannel fileChannel = fis.getChannel();
                try {
                    StringBuilder text = new StringBuilder();
                    ByteBuffer buffer = ByteBuffer.allocate(4096);
                    CharBuffer charBuffer = CharBuffer.allocate(4096);
                    while (fileChannel.read(buffer) != -1) {
                        buffer.flip();
                        DECODER.decode(buffer, charBuffer, false);
                        charBuffer.flip();
                        while (charBuffer.hasRemaining()) {
                            text.append(charBuffer.get());
                        }
                        buffer.clear();
                        charBuffer.clear();
                    }
                    string = text.toString();
                    if (fileChannel == null) break block15;
                }
                catch (Throwable throwable) {
                    if (fileChannel != null) {
                        try {
                            fileChannel.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                fileChannel.close();
            }
            return string;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static byte[] readFileBytes(File file) {
        String result;
        if (file.exists() && (result = DiskUtils.readFile(file)) != null) {
            return ByteUtils.toBytes((String)result);
        }
        return null;
    }

    public static byte[] readFileBytes(String path, String fileName) {
        File file = DiskUtils.openFile(path, fileName);
        return DiskUtils.readFileBytes(file);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static boolean writeFile(File file, byte[] content, boolean append) {
        try (FileOutputStream fos = new FileOutputStream(file, append);){
            boolean bl;
            block14: {
                FileChannel fileChannel = fos.getChannel();
                try {
                    ByteBuffer buffer = ByteBuffer.wrap(content);
                    fileChannel.write(buffer);
                    bl = true;
                    if (fileChannel == null) break block14;
                }
                catch (Throwable throwable) {
                    if (fileChannel != null) {
                        try {
                            fileChannel.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                fileChannel.close();
            }
            return bl;
        }
        catch (IOException ioe) {
            String errMsg;
            if (ioe.getMessage() != null && (NO_SPACE_CN.equals(errMsg = ioe.getMessage()) || NO_SPACE_EN.equals(errMsg) || errMsg.contains(DISK_QUOTA_CN) || errMsg.contains(DISK_QUOTA_EN))) {
                LOGGER.warn("\u78c1\u76d8\u6ee1\uff0c\u81ea\u6740\u9000\u51fa");
                System.exit(0);
            }
            return false;
        }
    }

    public static void deleteQuietly(File file) {
        Objects.requireNonNull(file, "file");
        FileUtils.deleteQuietly((File)file);
    }

    public static void deleteQuietly(Path path) {
        Objects.requireNonNull(path, "path");
        FileUtils.deleteQuietly((File)path.toFile());
    }

    public static boolean deleteFile(String path, String fileName) {
        File file = Paths.get(path, fileName).toFile();
        if (file.exists()) {
            return file.delete();
        }
        return false;
    }

    public static void deleteDirectory(String path) throws IOException {
        FileUtils.deleteDirectory((File)new File(path));
    }

    public static void forceMkdir(String path) throws IOException {
        FileUtils.forceMkdir((File)new File(path));
    }

    public static void forceMkdir(File file) throws IOException {
        FileUtils.forceMkdir((File)file);
    }

    public static void deleteDirThenMkdir(String path) throws IOException {
        DiskUtils.deleteDirectory(path);
        DiskUtils.forceMkdir(path);
    }

    public static void copyDirectory(File srcDir, File destDir) throws IOException {
        FileUtils.copyDirectory((File)srcDir, (File)destDir);
    }

    public static void copyFile(File src, File target) throws IOException {
        FileUtils.copyFile((File)src, (File)target);
    }

    public static File openFile(String path, String fileName) {
        return DiskUtils.openFile(path, fileName, false);
    }

    public static File openFile(String path, String fileName, boolean rewrite) {
        File directory = new File(path);
        boolean mkdirs = true;
        if (!directory.exists()) {
            mkdirs = directory.mkdirs();
        }
        if (!mkdirs) {
            LOGGER.error("[DiskUtils] can't create directory");
            return null;
        }
        File file = new File(path, fileName);
        try {
            boolean create = true;
            if (!file.exists()) {
                file.createNewFile();
            }
            if (file.exists()) {
                if (rewrite) {
                    file.delete();
                } else {
                    create = false;
                }
            }
            if (create) {
                file.createNewFile();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return file;
    }

    public static void compress(String rootDir, String sourceDir, String outputFile, Checksum checksum) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(outputFile);
             CheckedOutputStream cos = new CheckedOutputStream(fos, checksum);
             ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(cos));){
            DiskUtils.compressDirectoryToZipFile(rootDir, sourceDir, zos);
            zos.flush();
            fos.getFD().sync();
        }
    }

    private static void compressDirectoryToZipFile(String rootDir, String sourceDir, ZipOutputStream zos) throws IOException {
        File[] files;
        String dir = Paths.get(rootDir, sourceDir).toString();
        for (File file : files = Objects.requireNonNull(new File(dir).listFiles(), "files")) {
            String child = Paths.get(sourceDir, file.getName()).toString();
            if (file.isDirectory()) {
                DiskUtils.compressDirectoryToZipFile(rootDir, child, zos);
                continue;
            }
            try (FileInputStream fis = new FileInputStream(file);
                 BufferedInputStream bis = new BufferedInputStream(fis);){
                DiskUtils.compressIntoZipFile(child, bis, zos);
            }
        }
    }

    public static void compressIntoZipFile(String childName, InputStream inputStream, String outputFile, Checksum checksum) throws IOException {
        try (FileOutputStream fileOutputStream = new FileOutputStream(outputFile);
             CheckedOutputStream checkedOutputStream = new CheckedOutputStream(fileOutputStream, checksum);
             ZipOutputStream zipStream = new ZipOutputStream(new BufferedOutputStream(checkedOutputStream));){
            DiskUtils.compressIntoZipFile(childName, inputStream, zipStream);
            zipStream.flush();
            fileOutputStream.getFD().sync();
        }
    }

    private static void compressIntoZipFile(String childName, InputStream inputStream, ZipOutputStream zipOutputStream) throws IOException {
        zipOutputStream.putNextEntry(new ZipEntry(childName));
        IOUtils.copy((InputStream)inputStream, (OutputStream)zipOutputStream);
    }

    public static void decompress(String sourceFile, String outputDir, Checksum checksum) throws IOException {
        try (FileInputStream fis = new FileInputStream(sourceFile);
             CheckedInputStream cis = new CheckedInputStream(fis, checksum);
             ZipInputStream zis = new ZipInputStream(new BufferedInputStream(cis));){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                String fileName = entry.getName();
                File entryFile = new File(Paths.get(outputDir, fileName).toString());
                FileUtils.forceMkdir((File)entryFile.getParentFile());
                try (FileOutputStream fos = new FileOutputStream(entryFile);
                     BufferedOutputStream bos = new BufferedOutputStream(fos);){
                    IOUtils.copy((InputStream)zis, (OutputStream)bos);
                    bos.flush();
                    fos.getFD().sync();
                }
            }
            IOUtils.copy((InputStream)cis, (OutputStream)NullOutputStream.NULL_OUTPUT_STREAM);
        }
    }

    public static byte[] decompress(String sourceFile, Checksum checksum) throws IOException {
        byte[] result;
        try (FileInputStream fis = new FileInputStream(sourceFile);
             CheckedInputStream cis = new CheckedInputStream(fis, checksum);
             ZipInputStream zis = new ZipInputStream(new BufferedInputStream(cis));
             ByteArrayOutputStream bos = new ByteArrayOutputStream(1024);){
            while (zis.getNextEntry() != null) {
                IOUtils.copy((InputStream)zis, (OutputStream)bos);
                bos.flush();
            }
            IOUtils.copy((InputStream)cis, (OutputStream)NullOutputStream.NULL_OUTPUT_STREAM);
            result = bos.toByteArray();
        }
        return result;
    }

    public static LineIterator lineIterator(File file, String encoding) throws IOException {
        return new LineIterator(FileUtils.lineIterator((File)file, (String)encoding));
    }

    public static LineIterator lineIterator(File file) throws IOException {
        return new LineIterator(FileUtils.lineIterator((File)file, null));
    }

    public static class LineIterator
    implements AutoCloseable {
        private final org.apache.commons.io.LineIterator target;

        LineIterator(org.apache.commons.io.LineIterator target) {
            this.target = target;
        }

        public boolean hasNext() {
            return this.target.hasNext();
        }

        public String next() {
            return this.target.next();
        }

        public String nextLine() {
            return this.target.nextLine();
        }

        @Override
        public void close() throws IOException {
            this.target.close();
        }

        public void remove() {
            this.target.remove();
        }

        public void forEachRemaining(Consumer<? super String> action) {
            this.target.forEachRemaining(action);
        }
    }
}

